<?php
/*
 * $Horde: kronolith/prefs.php,v 1.4 2001/08/16 10:30:15 jan Exp $
 *
 * Copyright 2001 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Encapsulate the logic saying whether or not a preferences group is
 * editable.
 */
function groupIsEditable($group)
{
    global $prefs, $prefGroups;
    static $results;
    
    if (!isset($results)) $results = array();
    
    if (!isset($results[$group])) {
        $results[$group] = false;
        foreach ($prefGroups[$group]['members'] as $pref) {
            if (!$prefs->isLocked($pref)) {
                $results[$group] = true;
                return true;
            }
        }
    } else {
        return $results[$group];
    }

    return false;
}


require_once './lib/base.php';
require KRONOLITH_BASE . '/config/prefs.php';

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');

/* Run through the action handlers */
$actionID = Horde::getFormData('actionID', NO_ACTION);
switch ($actionID) {
    
 case NO_ACTION:
     break;
     
 case UPDATE_PREFS:
     if (isset($group) && groupIsEditable($group)) {
         $updated = false;
     
         foreach ($prefGroups[$group]['members'] as $pref) {
             if (!$prefs->isLocked($pref) ||
                 $_prefs[$pref]['type'] == 'special') {
                 switch ($_prefs[$pref]['type']) {
             
                     // These either aren't set or are set in other parts
                     // of the UI.
                 case 'implicit':
                 case 'link':
                     break;
             
                 case 'select':
                 case 'text':
                 case 'textarea':
                     $prefs->setValue($pref, Horde::getFormData($pref));
                     $updated = true;
                     break;
             
                 case 'enum':
                     $val = Horde::getFormData($pref);
                     if (isset($_prefs[$pref]['enum'][$val])) {
                         $prefs->setValue($pref, $val);
                         $updated = true;
                     } else {
                         Horde::raiseMessage(_("An illegal value was specified."), HORDE_ERROR);
                     }
                     break;
             
                 case 'number':
                     $num = Horde::getFormData($pref);
                     if (intval($num) != $num) {
                         Horde::raiseMessage(_("This value must be a number."), HORDE_ERROR);
                     } elseif ($num == 0) {
                         Horde::raiseMessage(_("This number must be at least one."), HORDE_ERROR);
                     } else {
                         $prefs->setValue($pref, $num);
                         $updated = true;
                     }
                     break;
             
                 case 'checkbox':
                     $val = Horde::getFormData($pref);
                     $prefs->setValue($pref, isset($val) ? 1 : 0);
                     $updated = true;
                     break;
             
                 case 'special':
                     // Code for special elements must be written
                     // specifically for each application.
                     break;
             
                 }
             }
         }
     
         // Do anything that you need to do as a result of certain
         // preferences changing.
         if ($prefs->isDirty('language')) {
             Lang::select(true);
         }
     
         if ($updated) {
             $prefs->store();
             Horde::raiseMessage(_("Your preferences have been updated."), HORDE_MESSAGE);
             $group = null;
         }
     }
    
     break;
}

/*
 * Assign variables to hold select lists
 */
if (!$prefs->isLocked('language')) {
    $language_options = &$nls['languages'];
}

if (!$prefs->isLocked('timezone')) {
    $timezone_options = &$tz;
}

$title = _("User Preferences");
require $registry->getTemplatePath() . '/common-header.inc';
require KRONOLITH_BASE . '/menu.php';

if (!empty($group) &&
    groupIsEditable($group)) {
    include $registry->getTemplatePath("horde") . '/prefs/begin.inc';
    foreach ($prefGroups[$group]['members'] as $pref) {
        if (!$prefs->isLocked($pref)) {
            switch ($_prefs[$pref]['type']) {
             case 'implicit':
                break;
                
             case 'special':
                include $registry->getTemplatePath() . "/prefs/$pref.inc";
                break;
                
             default:
                include $registry->getTemplatePath("horde") . '/prefs/' . $_prefs[$pref]['type'] . '.inc';
                break;
            }
        }
    }
    include $registry->getTemplatePath("horde") . '/prefs/end.inc';
} else {
    foreach ($prefGroups as $group => $gvals) {
        $col = $gvals['column'];
        unset($gvals['column']);
        $columns[$col][$group] = $gvals;
    }
    $span = round(100 / count($columns));
    include $registry->getTemplatePath("horde") . '/prefs/overview.inc';
}

$registry->shutdown();
require $registry->getTemplatePath() . '/common-footer.inc';

?>
