<?php
/*
 * $Horde: kronolith/month.php,v 1.64 2001/12/08 01:42:53 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function time_compare($x, $y)
{
    $a = mktime(date('G', $x['d']), date('i', $x['d']), date('s', $x['d']));
    $b = mktime(date('G', $y['d']), date('i', $y['d']), date('s', $y['d']));
    
    if ($a < $b)
        return -1;
    elseif ($a == $b)
        return 0;
    else
        return 1;
}


define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

if ($timestamp = Horde::getFormData('timestamp')) {
    $month = date('m', $timestamp);
    $year = date('Y', $timestamp);
} else {
    $month = Horde::getFormData('month', date('n'));
    $year = Horde::getFormData('year', date('Y'));
}
$timestamp = mktime(1,1,1, $month, 1, $year);
$prevstamp = mktime(1,1,1, $month - 1, 1, $year);
$nextstamp = mktime(1,1,1, $month + 1, 1, $year);
$title = strftime('%B %Y', $timestamp);

if ($conf['compress_pages']) {
    include_once 'HTTP/Compress.php';
    HTTP_Compress::start();
}

require $registry->getTemplatePath() . '/common-header.inc';
require KRONOLITH_BASE . '/menu.php';
require $registry->getTemplatePath() . '/javascript/delete.inc';
require $registry->getTemplatePath() . '/month/head.inc';

$daysInMonth = Kronolith::daysInMonth($month, $year);
$startday = Kronolith::dayOfWeek($year, $month, $prefs->getValue('week_start_monday') ? 1 : 2);

$events = $calendar->listEvents(Kronolith::dateObject(array('year' => $year, 'month' => $month, 'mday' => 1)), 
                                Kronolith::dateObject(array('year' => $year, 'month' => $month, 'mday' => $daysInMonth)));

$startOfMonthTimestamp = mktime(0, 0, 0, $month, 1, $year);
foreach ($events as $eventID) {
	$event = $calendar->getEventObject($eventID);
    $id = $event->getID();
	if (!$event->hasRecurType(KRONOLITH_RECUR_NONE)) {
		// We need to make sure that we only ask for recurrences
		// inside the date range.
        if ($event->getStartTimestamp() <= $startOfMonthTimestamp) {
			$mday = 1;
		} else {
		    $date_array[$event->getStartDate('j')][$id]['title'] = $event->getTitle();
		    $date_array[$event->getStartDate('j')][$id]['d'] = $event->getStartTimestamp();
		    $date_array[$event->getStartDate('j')][$id]['id'] = $id;
		    $date_array[$event->getStartDate('j')][$id]['alarm'] = $event->alarm;
		    $date_array[$event->getStartDate('j')][$id]['recurType'] = $event->recurType;
            $mday = date('j', mktime(0,0,0,$event->getStartDate('n'), $event->getStartDate('j') + 1, $event->getStartDate('Y')));
		}
		
		$next = $calendar->nextRecurrence($eventID, array('year' => $year, 'month' => $month, 'mday' => $mday));
		while (is_object($next) && 
		       isset($next->year) && 
		       (Kronolith::compareDates($next, array('year' => $year, 'month' => $month, 'mday' => $daysInMonth, 'hour' => 23, 'min' => 59, 'sec' => 59)) <= 0)) {
		    $date_array[$next->mday][$id]['title'] = $event->getTitle();
		    $date_array[$next->mday][$id]['d'] = $event->getStartTimestamp();
		    $date_array[$next->mday][$id]['id'] = $id;
		    $date_array[$next->mday][$id]['alarm'] = $event->alarm;
		    $date_array[$next->mday][$id]['recurType'] = $event->recurType;
		    $next = $calendar->nextRecurrence($eventID, array('year' => $next->year, 'month' => $next->month, 'mday' => $next->mday + 1, 'hour' => $next->hour, 'min' => $next->min, 'sec' => $next->sec));
		}
	} else {
        // Similar logic will need to be added above in the recurrences
        // section when recurrences are implemented for the sql driver.
        if ($event->getStartDate('n') < $month ||
            $event->getStartDate('Y') < $year) {
            $eventStartDay = 1;
        } else {
            $eventStartDay = $event->getStartDate('j');
        }
 
        if ($event->getEndDate('n') > $month ||
            $event->getEndDate('Y') > $year) {
            $eventEndDay = $daysInMonth;
        } else {
            // If the event doesn't end at 12am set the end date to 
            // the current end date. If it ends at 12am set the end
            // date to the previous days end date.
            if ($event->getEndDate('G') != 0 || 
                $event->getEndDate('i') != 0) {
                $eventEndDay = $event->getEndDate('j');
            } else {
                $eventEndDay = $event->getEndDate('j') - 1;
            }
        }
        
        for ($i = $eventStartDay; $i <= $eventEndDay; $i++) {
            $date_array[$i][$id]['title'] = $event->getTitle();
            $date_array[$i][$id]['d'] = $event->getStartTimestamp();
            $date_array[$i][$id]['id'] = $id;
            $date_array[$i][$id]['alarm'] = $event->alarm;
            $date_array[$i][$id]['recurType'] = $event->recurType;
        }
	}
}

for ($i = 0; $i < $startday; $i++) { 
	echo '<td></td>';
}
$dayofweek = $startday;
for ($i = 1; $i <= $daysInMonth; $i++) {
    if (($dayofweek % 7 == 0) && ($dayofweek != 0)) {
        echo "</tr>\n<tr>";
    }
    if (mktime(0,0,0) == mktime(0,0,0, $month, $i, $year)) {
        $style = 'selected';
    } elseif (isset($date_array[$i]) && is_array($date_array[$i])) {
        $style = 'text';
    } else {
        $style = 'item';
    }
    echo '<td class="' . $style . '" height="100" width="14%" valign="top">';
    echo '<a href="' . Horde::applicationUrl("addevent.php?month=$month&year=$year&mday=$i&url=" . urlencode($HTTP_SERVER_VARS['REQUEST_URI'])) . '">' . Horde::img('new.gif', 'align="right" alt="' . _("Create a New Event") . '"') . "</a>";
    echo '<b><a class="day" href="' . Horde::applicationUrl("day.php?month=$month&year=$year&mday=$i") . "\">&nbsp;$i&nbsp;</a></b>";
    if (($dayofweek % 7 == 0) && (($dayofweek != 0 || $startday == 0))) {
        if ($month == 12 && Kronolith::weekOfYear($i, $month, $year) == 1) {
            echo ' (' . Horde::link(Horde::applicationUrl('week.php?week=' . Kronolith::weekOfYear($i, $month, $year) . '&year=' . ($year+1)), sprintf(_("Week %d"), Kronolith::weekOfYear($i, $month, $year))) . sprintf(_("Week&nbsp;%d"), Kronolith::weekOfYear($i, $month, $year)) . '</a>)';
        } else {
            echo ' (' . Horde::link(Horde::applicationUrl('week.php?week=' . Kronolith::weekOfYear($i, $month, $year) . '&year=' . $year), sprintf(_("Week %d"), Kronolith::weekOfYear($i, $month, $year))) . sprintf(_("Week&nbsp;%d"), Kronolith::weekOfYear($i, $month, $year)) . '</a>)';
        }
    }
    
    if (isset($date_array[$i]) && is_array($date_array[$i])) {
        echo '<p>';
        usort($date_array[$i], 'time_compare');
        foreach ($date_array[$i] as $e) {
            echo Horde::link(Horde::applicationUrl('editevent.php?eventID=' . $e['id'] . "&month=$month&year=$year&mday=$i&url=" . urlencode($HTTP_SERVER_VARS['REQUEST_URI'])), $e['title'], 'event');
            Horde::pimg('bullet.gif', 'align="bottom" alt="*"');
            echo htmlspecialchars($e['title']) . '</a>';
            echo Horde::link(Horde::applicationUrl('delevent.php?eventID=' . $e['id'] . "&month=$month&year=$year&mday=$i&url=" . urlencode($HTTP_SERVER_VARS['REQUEST_URI'])), sprintf(_("Delete '%s'"), htmlspecialchars($e['title'])), '', '', 'return confirmDelete(\'' . addslashes(htmlspecialchars($e['title'])) . '\')');
            echo Horde::img('delete.gif', 'alt="' . sprintf(_("Delete '%s'"), htmlspecialchars($e['title'])) . '"') . '</a>';
            if ($e['alarm']) echo Horde::img('alarm_small.gif', 'alt="' . $e['alarm'] . ' ' . _("Minutes before") . '"');
            if ($e['recurType'] != KRONOLITH_RECUR_NONE) echo Horde::img('recur.gif', 'alt="' . Kronolith::recurToString($e['recurType']) . '"');
            echo '<br />';
        }
        echo '</p>';
    }
    echo '</td>';
    $dayofweek++;
}
?>
</tr></table>
</td></tr></table>

<?php

require $registry->getTemplatePath() . '/common-footer.inc';

if ($conf['compress_pages']) {
    HTTP_Compress::output();
}

?>
