<?php
/*
 * $Horde: kronolith/menu.php,v 1.13 2001/09/18 16:03:51 jan Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999, 2000 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL). If you did
 * not receive such a file, see also http://www.fsf.org/copyleft/gpl.html.
 */

require_once HORDE_BASE . '/lib/Menu.php';

/* Check for additional site-specific menu items (in config/menu.php). */
$additional_items = '';
if (@is_readable(KRONOLITH_BASE . '/config/menu.php')) {
    include_once KRONOLITH_BASE . '/config/menu.php';
    foreach ($_menu as $item) {
        $additional_items .= Menu::customItem($item);
    }
}

$timestamp = Horde::getFormData('timestamp');
if (!$timestamp) {
    $year = Horde::getFormData('year', date('Y'));
    $month = Horde::getFormData('month', date('m'));
    $day = Horde::getFormData('mday', date('d'));
    if ($week = Horde::getFormData('week')) {
        $month = 1;
        $day = Kronolith::firstDayOfWeek($week, $year);
    }
    $timestamp = mktime(0, 0, 0, $month, $day, $year);
}
$append = "?timestamp=$timestamp";
  
include $registry->getTemplatePath() . '/menu/menu.inc';
require './status.php';

/* Include the JavaScript for the help system (if enabled). */
if ($conf['user']['online_help'] && $browser->hasFeature('javascript')) {
    Help::javascript();
}

?>
