<?php
// $Horde: kronolith/lib/base.php,v 1.29 2001/11/07 09:21:31 chuck Exp $

/*
 * Kronolith base inclusion file.
 *
 * This file brings in all of the dependencies that every Kronolith
 * script will need, and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Kronolith
@define('KRONOLITH_BASE', dirname(__FILE__) . '/..');

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';
$browser = new Browser();
if ($browser->hasQuirk('cache_ssl_downloads')
    && isset($HTTP_SERVER_VARS['HTTPS'])
    && ($HTTP_SERVER_VARS['HTTPS'] == 'on')) {
    session_cache_limiter('private, must-revalidate');
}

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('kronolith');
$conf = &$GLOBALS['conf'];

// set error reporting according to config settings
error_reporting($conf['debug_level']);

// set max execution time according to config settings
set_time_limit($conf['max_exec_time']);

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';

// Kronolith base library
require_once KRONOLITH_BASE . '/lib/Kronolith.php';

// Help
require_once HORDE_BASE . '/lib/Help.php';

// PEAR Date_Calc
require_once 'Date/Calc.php';

// Don't allow access unless there is a Horde login
if (!Auth::getAuth()) {
    header('Location: ' . Horde::url($registry->getWebRoot("horde") . '/login.php?url=' . urlencode($HTTP_SERVER_VARS['PHP_SELF']), true));
    exit;
}

// Set the timezone variable, if available.
$timezone = $GLOBALS['prefs']->getValue('timezone');
if (isset($timezone)) {
    putenv('TZ=' . $timezone);
}

// Open the users calendar
$GLOBALS['calendar'] = &Kronolith_Driver::factory($conf['calendar']['driver'], $conf['calendar']['params']);
$GLOBALS['calendar']->open(Auth::getAuth());

?>
