<?php
/*
 * $Horde: kronolith/delevent.php,v 1.25 2001/10/15 11:01:41 jan Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

if ($event = Horde::getFormData('eventID')) {
    $calendar->deleteEvent($event);
}

if ($timestamp = Horde::getFormData('timestamp')) {
    $month = date('n', $timestamp);
    $year = date('Y', $timestamp);
} else {
    $month = (Horde::getFormData('month', date('n')));
    $year = (Horde::getFormData('year', date('Y')));
}

if ($url = Horde::getFormData('url')) {
    $location = Horde::applicationUrl(urldecode($url), true);
} else {
    $location = Horde::applicationUrl($prefs->getValue('defaultview') . ".php?month=$month&year=$year", true);
}

// make url unique
if (strpos($location, '?') !== false) {
    $location .= '&';
} else {
    $location .= '?';
}
$location .= 'unique=' . md5(microtime());
  
header('Location: ' . $location);

?>
