<?php
/*
 * $Horde: kronolith/addevent.php,v 1.30 2001/09/18 16:03:50 jan Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require KRONOLITH_BASE . '/lib/base.php';

$event = $calendar->getEventObject();

if (!$timestamp = Horde::getFormData('timestamp')) {
    $month = Horde::getFormData('month', date('n'));
    $day = Horde::getFormData('mday', date('j'));
    $year = Horde::getFormData('year', date('Y'));
    $timestamp = mktime(8, 0, 0, $month, $day, $year);
}

$url = Horde::getFormData('url');

$event->setStartTimestamp($timestamp);
$event->setEndTimestamp($timestamp);
$event->setRecurType(KRONOLITH_RECUR_NONE);
$month = date('n', $timestamp);
$year = date('Y', $timestamp);

$title = _("Add a new event");

require $registry->getTemplatePath() . '/common-header.inc';
require './menu.php';
require $registry->getTemplatePath() . '/edit/javascript.inc';
require $registry->getTemplatePath() . '/edit/edit.inc';
require $registry->getTemplatePath() . '/common-footer.inc';

?>
