<?php
/*
 * $Horde: kronolith/status.php,v 1.6 2001/03/21 15:42:45 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999, 2000 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */


// get any events or alarms in the next hour
// TODO: alarms. how the heck do they work?
$current_date = getdate();
$myDay = $current_date['mday'];
$myMonth = $current_date['mon'];
$myYear = $current_date['year'];
$now = mktime();
$events = $calendar->listEvents(array('year' => $myYear, 'month' => $myMonth, 'day' => $myDay), array('year' => $myYear, 'month' => $myMonth, 'day' => $myDay));
$messages = array();
foreach ($events as $eventID) {
	$thisEvent = $calendar->getEventObject($eventID);
    $differential = $thisEvent->getStartTimestamp($now) - $now;
    if ($differential >= -60 && $differential < 60) {
        $messages[$thisEvent->getStartTimestamp()] = array(sprintf(_("%s is starting now."), $thisEvent->getTitle()), KRONOLITH_ALARM);
    } else if ($differential < 0 && $now <= $thisEvent->getEndTimestamp()) {
        $messages[$thisEvent->getStartTimestamp()] = array(sprintf(_("%s is in progress."), $thisEvent->getTitle()), KRONOLITH_EVENT);
    } else if ($differential >= 60 && $differential < 7200) {
        $messages[$thisEvent->getStartTimestamp()] = array(sprintf(_("%s starts in %s"), $thisEvent->getTitle(), Kronolith::secondsToString($differential)), KRONOLITH_ALARM);
    }
}
ksort($messages);
foreach ($messages as $message) {
    Horde::raiseMessage($message[0], $message[1]);
}

if (isset($hordeMessageStack) && is_array($hordeMessageStack)) {
    echo '<table width="100%" border="0" cellpadding="0" cellspacing="0"><tr><td class="item"><table border="0" cellspacing="2" cellpadding="2" width="100%">';
    foreach ($hordeMessageStack as $message) {
        switch ($message['type']) {
        case KRONOLITH_ALARM:
            echo '<tr><td class="control">' . Horde::img('alarm.gif') . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        case KRONOLITH_EVENT:
            echo '<tr><td class="control">' . Horde::img('event.gif') . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        case HORDE_ERROR:
            echo '<tr><td class="control">' . Horde::img('alerts/error.gif', 'alt="' . _("Error") . '"', $conf['horde']['paths']['graphics']) . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        case HORDE_SUCCESS:
            echo '<tr><td class="control">' . Horde::img('alerts/success.gif', 'alt="' . _("Success") . '"', $conf['horde']['paths']['graphics']) . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        case HORDE_WARNING:
            echo '<tr><td class="control">' . Horde::img('alerts/warning.gif', 'alt="' . _("Warning") . '"', $conf['horde']['paths']['graphics']) . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        case HORDE_MESSAGE:
        default:
            echo '<tr><td class="control">' . Horde::img('alerts/message.gif', 'alt="' . _("Message") . '"', $conf['horde']['paths']['graphics']) . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;
            
        }
    }
    echo '</table></td></tr></table>';
}
?>
