<?php
/*
 * $Horde: kronolith/prefs.php,v 1.2 2001/05/30 21:02:18 chuck Exp $
 *
 * Copyright 2001 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Encapsulate the logic saying whether or not a preferences group is
 * editable.
 */
function groupIsEditable($group)
{
    global $prefs, $prefGroups;
    static $results;
    
    if (!isset($results)) $results = array();
    
    if (!isset($results[$group])) {
        $results[$group] = false;
        foreach ($prefGroups[$group]['members'] as $pref) {
            if (!$prefs->isLocked($pref)) {
                $results[$group] = true;
                return true;
            }
        }
    } else {
        return $results[$group];
    }

    return false;
}


require_once './lib/base.php';
require KRONOLITH_BASE . '/config/prefs.php';

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');

/* Run through the action handlers */
$actionID = Horde::getFormData('actionID', NO_ACTION);
switch ($actionID) {
    
 case NO_ACTION:
     break;
     
 case UPDATE_PREFS:
     if (isset($group) && groupIsEditable($group)) {
         $updated = false;
     
         foreach ($prefGroups[$group]['members'] as $pref) {
             if (!$prefs->isLocked($pref) ||
                 $_prefs[$pref]['type'] == 'special') {
                 switch ($_prefs[$pref]['type']) {
             
                     // These either aren't set or are set in other parts
                     // of the UI.
                 case 'implicit':
                 case 'link':
                     break;
             
                 case 'select':
                 case 'text':
                 case 'textarea':
                     $prefs->setValue($pref, Horde::getFormData($pref));
                     $updated = true;
                     break;
             
                 case 'enum':
                     $val = Horde::getFormData($pref);
                     if (isset($_prefs[$pref]['enum'][$val])) {
                         $prefs->setValue($pref, $val);
                         $updated = true;
                     } else {
                         Horde::raiseMessage(_("An illegal value was specified."), HORDE_ERROR);
                     }
                     break;
             
                 case 'number':
                     $num = Horde::getFormData($pref);
                     if (intval($num) != $num) {
                         Horde::raiseMessage(_("This value must be a number."), HORDE_ERROR);
                     } elseif ($num == 0) {
                         Horde::raiseMessage(_("This number must be at least one."), HORDE_ERROR);
                     } else {
                         $prefs->setValue($pref, $num);
                         $updated = true;
                     }
                     break;
             
                 case 'checkbox':
                     $val = Horde::getFormData($pref);
                     $prefs->setValue($pref, isset($val) ? 1 : 0);
                     $updated = true;
                     break;
             
                 case 'special':
                     // Code for special elements must be written
                     // specifically for each application.
                     break;
             
                 }
             }
         }
     
         // Do anything that you need to do as a result of certain
         // preferences changing.
         if ($prefs->isDirty('language')) {
             Lang::select(true);
         }
     
         if ($updated) {
             $prefs->store();
             Horde::raiseMessage(_("Your preferences have been updated."), HORDE_MESSAGE);
             $group = null;
         }
     }
    
     break;
}

/*
 * Assign variables to hold select lists
 */
if (!$prefs->isLocked('language')) {
    $language_options = &$nls['languages'];
}

$title = _("User Preferences");
require $conf['paths']['templates'] . '/common-header.inc';
require KRONOLITH_BASE . '/menu.php';

if (!empty($group) &&
    groupIsEditable($group)) {
    include $conf['horde']['paths']['templates'] . '/prefs/begin.inc';
    foreach ($prefGroups[$group]['members'] as $pref) {
        if (!$prefs->isLocked($pref)) {
            switch ($_prefs[$pref]['type']) {
             case 'implicit':
                break;
                
             case 'special':
                include $conf['paths']['templates'] . "/prefs/$pref.inc";
                break;
                
             default:
                include $conf['horde']['paths']['templates'] . '/prefs/' . $_prefs[$pref]['type'] . '.inc';
                break;
            }
        }
    }
    include $conf['horde']['paths']['templates'] . '/prefs/end.inc';
} else {
    foreach ($prefGroups as $group => $gvals) {
        $col = $gvals['column'];
        unset($gvals['column']);
        $columns[$col][$group] = $gvals;
    }
    $span = round(100 / count($columns));
    include $conf['horde']['paths']['templates'] . '/prefs/overview.inc';
}

$registry->shutdown();
require $conf['paths']['templates'] . '/common-footer.inc';

?>
