<?php
/*
 * $Horde: kronolith/month.php,v 1.45 2001/06/08 20:23:29 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function date_compare($x, $y)
{
    $a = mktime(date('G', $x['d']), date('i', $x['d']), date('s', $x['d']));
    $b = mktime(date('G', $y['d']), date('i', $y['d']), date('s', $y['d']));
    
    if ($a < $b)
        return -1;
    elseif ($a == $b)
        return 0;
    else
        return 1;
}


define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

$month = Horde::getFormData('month', date('n'));
$year = Horde::getFormData('year', date('Y'));
$timestamp = mktime(1,1,1, $month, 1, $year);
$prevstamp = mktime(1,1,1, $month - 1, 1, $year);
$nextstamp = mktime(1,1,1, $month + 1, 1, $year);
$title = strftime('%B, %Y', $timestamp);

require $conf['paths']['templates'] . '/common-header.inc';
require KRONOLITH_BASE . '/menu.php';
require $conf['paths']['templates'] . '/month/head.inc';

$daysInMonth = Kronolith::daysInMonth($month, $year);
$startday = Kronolith::dayOfWeek($year, $month, 1);

$events = $calendar->listEvents(array('year' => $year, 'month' => $month, 'day' => 1), array('year' => $year, 'month' => $month, 'day' => $daysInMonth));

$startOfMonthTimestamp = mktime(0, 0, 0, $month, 1, $year);
foreach ($events as $eventID) {
	$event = $calendar->getEventObject($eventID);
    $id = $event->getID();
	if (!$event->hasRecurType(KRONOLITH_RECUR_NONE)) {
		// We need to make sure that we only ask for recurrences
		// inside the date range.
        if ($event->getStartTimestamp() <= $startOfMonthTimestamp) {
			$mday = 1;
		} else {
		    $date_array[$event->getStartDate('j')][$id]['title'] = $event->getTitle();
		    $date_array[$event->getStartDate('j')][$id]['d'] = $event->getStartTimestamp();
		    $date_array[$event->getStartDate('j')][$id]['id'] = $id;
            $mday = date('j', mktime(0,0,0,$event->getStartDate('n'), $event->getStartDate('j') + 1, $event->getStartDate('Y')));
		}
		
		$next = $calendar->nextRecurrence($eventID, array('year' => $year, 'month' => $month, 'mday' => $mday));
		while (is_object($next) && isset($next->year) && (Kronolith::compareDates($next->year, $next->month, $next->mday, $year, $month, $daysInMonth) <= 0)) {
		    $date_array[$next->mday][$id]['title'] = $event->getTitle();
		    $date_array[$next->mday][$id]['d'] = $event->getStartTimestamp();
		    $date_array[$next->mday][$id]['id'] = $id;
		    $curday = $next->mday; $curmonth = $next->month; $curyear = $next->year;
		    $next = $calendar->nextRecurrence($eventID, array('year' => $curyear, 'month' => $curmonth, 'mday' => $curday + 1));
		}
	} else {
	    // It's not a recurring event, so it must be in the date
	    // range; add it.
	    $date_array[$event->getStartDate('j')][$id]['title'] = $event->getTitle();
	    $date_array[$event->getStartDate('j')][$id]['d'] = $event->getStartTimestamp();
	    $date_array[$event->getStartDate('j')][$id]['id'] = $id;
	}
}

for ($i = 0; $i < $startday; $i++) { 
	echo '<td></td>';
}
$dayofweek = $startday;
for ($i = 1; $i <= $daysInMonth; $i++) {
    if (($dayofweek % 7 == 0) && ($dayofweek != 0)) {
        echo "</tr>\n<tr>";
    }
    if (mktime(0,0,0) == mktime(0,0,0, $month, $i, $year)) {
        $style = 'selected';
    } elseif (isset($date_array[$i]) && is_array($date_array[$i])) {
        $style = 'text';
    } else {
        $style = 'item';
    }
    echo '<td class="' . $style . '" height="100" width="14%" valign="top">';
    echo "<a href=\"addevent.php?month=$month&year=$year&day=$i\">" . Horde::img('event.gif', 'align="right" alt="' . _("Create a New Event") . '"') . "</a>";
    echo '<b><a class="day" href="' . Horde::url("day.php?month=$month&year=$year&day=$i") . "\">&nbsp;$i&nbsp;</a></b>";
    if (($dayofweek % 7 == 0) && (($dayofweek != 0 || $startday == 0))) {
        echo ' (' . Horde::link(Horde::applicationUrl('week.php?week=' . Kronolith::weekOfYear($i, $month, $year) . '&year=' . $year), sprintf(_("Week %d"), Kronolith::weekOfYear($i, $month, $year))) . sprintf(_("Week&nbsp;%d"), Kronolith::weekOfYear($i, $month, $year)) . '</a>)';
    }
    
    if (isset($date_array[$i]) && is_array($date_array[$i])) {
        echo '<p>';
        usort($date_array[$i], 'date_compare');
        foreach ($date_array[$i] as $e) {
            echo Horde::link(Horde::applicationUrl('editevent.php?eventID=' . $e['id'] . "&month=$month&year=$year&day=$i"), $e['title'], 'event');
            Horde::pimg('bullet.gif', 'align="bottom" alt="*"');
            echo $e['title'] . '</a>';
            echo Horde::link(Horde::applicationUrl('delevent.php?eventID=' . $e['id'] . "&month=$month&year=$year&day=$i"), sprintf(_("Delete '%s'"), $e['title']));
            echo Horde::img('delete.gif', 'alt="' . sprintf(_("Delete '%s'"), $e['title']) . '"') . '</a><br />';
        }
        echo '</p>';
    }
    echo '</td>';
    $dayofweek++;
}
?>
</tr></table>
</td></tr></table>

<?php require $conf['paths']['templates'] . '/common-footer.inc'; ?>
