<?php
// $Horde: kronolith/lib/base.php,v 1.18 2001/06/12 20:36:54 chuck Exp $

/*
 * Kronolith base inclusion file.
 *
 * This file brings in all of the dependencies that every Kronolith
 * script will need, and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Kronolith
@define('KRONOLITH_BASE', dirname(__FILE__) . '/..');

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('kronolith');
$conf = &$GLOBALS['conf'];

// set error reporting according to config settings
error_reporting($conf['debug_level']);

// set max execution time according to config settings
set_time_limit($conf['max_exec_time']);

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Lang.php';

// Kronolith base library
require_once KRONOLITH_BASE . '/lib/Kronolith.php';

// Initialize the localization routines.
require HORDE_BASE . '/config/lang.php';
$language = Lang::select();
putenv("LANG=$language");
@setlocale(LC_ALL, $language);

// Code that should be run at the beginning of all Kronolith pages
session_name($conf['session_name']);
@session_start();

// Don't allow access unless there is a Horde login
if (!Auth::getAuth()) {
    header('Location: ' . Horde::url($conf['horde']['paths']['root'] . '/login.php?url=' . urlencode(Horde::selfUrl()), true));
}

// Retrieve the user's preferences
require_once HORDE_BASE . '/lib/Prefs.php';
$GLOBALS['prefs'] = Prefs::factory($conf['prefs']['driver'], $registry->getApp(),
                                   Auth::getAuth(), '', $conf['prefs']['params']);
$GLOBALS['prefs']->setDefaults(KRONOLITH_BASE . '/config/prefs.php');
$GLOBALS['prefs']->retrieve();

// Open the users calendar
$GLOBALS['calendar'] = Kronolith_Driver::factory($conf['calendar']['driver'], $conf['calendar']['params']);
$GLOBALS['calendar']->open(Auth::getAuth());

?>
