<?php
// $Horde: kronolith/lib/api.php,v 1.4 2001/06/12 20:23:22 chuck Exp $
/*
 * Kronolith external API interface.
 *
 * This file defines Kronolith's external API interface. Other
 * applications can interact with Kronolith through this API.
 */

// Find the base file paths for Kronolith
@define('KRONOLITH_BASE', dirname(__FILE__) . '/..');

// Include the necessary libraries.
require_once KRONOLITH_BASE . '/lib/base.php';

function kronolithSummary()
{
    global $prefs;
    
    $html = '<table border="0" cellpadding="2" cellspacing="0"><tr><td class="header">' . _("Calendar") . '</td></tr><tr><td class="text"><table border="0" cellpadding="0" cellspacing="0">';
    
    include_once KRONOLITH_BASE . '/lib/Day.php';
    $day = new Kronolith_Day();
    while ($day->getDayOfWeek() != 0 || $day->isToday()) {
        $html .= '<tr><td colspan="3" class="text"><b>';
        if ($day->isToday()) {
            $html .= _("Today");
        } else {
            $html .= strftime('%A', $day->getStamp());
        }
        $html .= '</b></td></tr>';
        
        $events = Kronolith::getEvents($day->getStamp());
        foreach ($events as $event) {
            $html .= '<tr><td class="text">';
            if ($event->start->hour != 0 || $event->start->min != 0 
                || ($event->end_time - $event->start_time) != (24 * 60 * 60)) {
                if ($prefs->getValue('24hr')) {
                    $time  = date('G:i', $event->start_time) . '-';
                    $time .= date('G:i', $event->end_time);
                } else {
                    $time  = date('g:i A', $event->start_time) . '-';
                    $time .= date('g:i A', $event->end_time);
                }
            } else {
                $time = _("All day");
            }

            $text = $event->title;
            if (!empty($event->attrlist['location'])) {
                $text .= ' (' . $event->attrlist['location'] . ')';
            }
            $html .= Horde::link(Horde::applicationUrl('editevent.php?eventID=' . 
                                                     $event->id), $event->title) . $time . '</a>';
            $html .= '</td><td class="text">&nbsp;&nbsp;&nbsp;</td><td class="text">';
            $html .= Horde::link(Horde::applicationUrl('editevent.php?eventID=' .
                                                     $event->id), $event->title) . $text . '</a>';
            $html .= '</tr>';
        }
        $day = new Kronolith_Day(null, null, null, $day->getTomorrow());
    }
    $html .= '</table></td></tr></table>';
    
    return $html;
}

?>
