<?php
// $Horde: kronolith/lib/WeekView.php,v 1.7 2001/05/31 03:59:03 chuck Exp $

/**
 * The Kronolith_WeekView:: class provides an API for viewing weeks.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.7 $
 * @since   Kronolith 0.1
 * @package kronolith
 */
class Kronolith_WeekView {
    
    var $parsed = false;
    var $days = array();
    var $columns = 0;
    var $week = null;
    var $year = null;
    var $startDay = 0;
    var $endDay = 6;
    
    
    function Kronolith_WeekView($week = null, $year = null, $startDay = null, $endDay = null)
    {
        if (!isset($year)) $year = date('Y');
        if (!isset($week)) {
            $week = Kronolith::weekOfYear(null, null, $year);
        } else {
            if ($week < 1) {
                $year--;
                $week += Kronolith::weeksInYear($year);
            } elseif ($week > Kronolith::weeksInYear($year)) {
                $week -= Kronolith::weeksInYear($year);
                $year++;
            }
        }
        
        $this->year = $year;
        $this->week = $week;
        
        if (isset($startDay)) $this->startDay = $startDay;
        if (isset($endDay)) $this->endDay = $endDay;
        
        $firstDay = Kronolith::firstDayOfWeek($week, $year);
        
        include_once KRONOLITH_BASE . '/lib/DayView.php';
        for ($i = $this->startDay; $i <= $this->endDay; $i++) {
            $this->days[$i] = new Kronolith_DayView(1, $firstDay + $i, $year);
        }
    }
    
    
    function html($template_path = './templates')
    {
        global $prefs;
        
        if (!$this->parsed) {
            $this->parse();
        }
        
        $hours = $this->days[$this->startDay]->Day->hours;
        for ($i = $this->startDay; $i <= $this->endDay; $i++) {
            $current_arr[$i] = array();
        }
        $started = false;
    
        include $template_path . '/week/head.inc';
        for ($i = 0; $i < count($hours); $i++) {
            if (!$started && (!isset($this->days[0]->lines[$i]) &&
                              !isset($this->days[1]->lines[$i]) &&
                              !isset($this->days[2]->lines[$i]) &&
                              !isset($this->days[3]->lines[$i]) &&
                              !isset($this->days[4]->lines[$i]) &&
                              !isset($this->days[5]->lines[$i]) &&
                              !isset($this->days[6]->lines[$i])) && $i < 16) {
                continue;
            }
            
            $started = true;
            $row = '';
            $time = date(($prefs->getValue('24hr')) ? 'G:i' : 'g:ia', $hours[$i]['timestamp']);
            $style = (floor($i/2) % 2) ? 'item1' : 'item0';
            
            for ($j = $this->startDay; $j <= $this->endDay; $j++) {
                $hspan = 0;
                $row_set = false;
                $current = 0;
                
                // add spacer between days
                $row .= '<td width="1%" class="text">&nbsp;</td>';
                
                if (count($current_arr[$j]) > 0) {
                    reset($current_arr[$j]);
                    while (list($id, $event) = each($current_arr[$j])) {
                        if (is_object($event)) {
                            $event->span = $event->span - 1;
                            if ($event->span == 0) {
                                $current_arr[$j][$id] = '';
                                unset($current_arr[$j][$id]);
                            } else {
                                $current++;
                                if ($event->overlap > $hspan)
                                    $hspan = $event->overlap;
                                $current_arr[$j][$id] = $event;
                            }
                        }
                    }
                    if ($current > 0) {
                        $row_set = true;
                    }
                }
                
                if (isset($this->days[$j]->lines[$i]) && is_array($this->days[$j]->lines[$i])) {
                    while (list(,$key) = each($this->days[$j]->lines[$i])) {
                        $event = &$this->days[$j]->event_arr[$key];
                        if ($event->overlap > $hspan)
                            $hspan = $event->overlap;
                        $row .= '<td class="eventbox' . ($event->color % 7) . '" valign="top" width="' . round(14 / $event->overlap) . '%" colspan="' . ($this->days[$j]->columns / $event->overlap) . '" rowspan="' . $event->span . '">'
                            . '<a href="' . Horde::applicationUrl("editevent.php?eventID=$event->id&timestamp=" . $this->days[$j]->Day->getStamp()) . '">' . $event->title . '</a>'
                            . '<a href="' . Horde::applicationUrl("delevent.php?eventID=$event->id&timestamp=" . $this->days[$j]->Day->getStamp()) . '"><img src="graphics/delete.gif" alt="' . _("Delete this event") . '" border="0" hspace="2" vspace="0"></a></td>' . "\n";
                        $row_set = true;
                        $current++;
                        $current_arr[$j][$event->id] = $event;
                    }
                }
                
                while ($current < $hspan) {
                    $row .= '<td width="' . round(100 / count($this->days)) . '%" colspan="' . ($this->days[$j]->columns / $hspan) . '" class="' . $style . '">&nbsp;</td>' . "\n";
                    $current++;
                }
                
                if (!$row_set) {
                    $row .= '<td width="' . round(100 / count($this->days)) . '%" colspan="' . $this->days[$j]->columns . '" class="' . $style . '">&nbsp;</td>' . "\n";
                }
            }
        
            if ($i % 2) {
                include $template_path . '/day/row_half.inc';
            } else {
                include $template_path . '/day/row.inc';
            }
        }
        include $template_path . '/day/foot.inc';
    }

    // This function runs through the events and tries to figure out
    // what should be on each line of the outputted table. This could
    // get complex...
    function parse()
    {
        for ($i = $this->startDay; $i <= $this->endDay; $i++) {
            $this->days[$i]->parse();
        }
        
        $this->columns = 0;
        for ($i = $this->startDay; $i <= $this->endDay; $i++) {
            $this->columns += $this->days[$i]->columns;
        }
    }
    
    function link($offset = 0)
    {
        $scriptName = basename($GLOBALS['HTTP_SERVER_VARS']['SCRIPT_NAME']);
        $week = $this->week + $offset;
        $year = $this->year;
        if ($week < 1) {
            $year--;
            $week += Kronolith::weeksInYear($year);
        } elseif ($week > Kronolith::weeksInYear($year)) {
            $week -= Kronolith::weeksInYear($year);
            $year++;
        }
        return Horde::applicationUrl($scriptName . '?week=' . $week . '&year=' . $year);
    }

}
?>
