<?php
// $Horde: kronolith/lib/Month.php,v 1.8 2001/01/26 21:54:19 chuck Exp $

/**
 * The Kronolith_Month:: class provides an API for dealing with months.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.8 $
 * @since   Kronolith 0.1
 * @package kronolith
 */
class Kronolith_Month {
  
	var $month;
	var $day;
	var $year;
	var $time;
	var $first;
	var $cal;
  
	function Kronolith_Month ($month='', $day='', $year='') {
		if ($month == '') {
			$month = date('m');
		}
    
		if ($year == '') {
			$year = date('Y');
		}
    
		if ($day == '') {
			$day = date('d');
		}
    
		// now, compensate for any wrap around
		$this->time = mktime(0,0,0,$month,$day,$year);
		$this->month = date('m', $this->time);
		$this->year = date('Y', $this->time);
		$this->day = date('d', $this->time);
		$this->first = date('w', mktime(0,0,0,$this->month,1,$this->year));
    
		// make the data array
		$this->makeCal();
	}
  
	function makeCal () {
		$this->cal = array();
    
		for ($i = 0; $i < $this->first; $i++) {
			$this->cal[0][$i] = '';
		}
    
		$row = 0;
		$pos = $this->first;
		$cur = 1;
    
		while ($this->month == date('m', mktime(0,0,0,$this->month,$cur,date('Y')))) {
			while ($this->month == date('m', mktime(0,0,0,$this->month,$cur,date('Y'))) && $pos < 7) {
				$this->cal[$row][$pos] = $cur;
				$pos++;
				$cur++;
			}
      
			if (!isset($this->cal[6])) {
				for ($i = $pos; $i < 7; $i++) {
					$this->cal[$row][$i] = '';
				}
			}
			$row++;
			$pos = 0;
		}
	} // makeCal()
  
	function getTime ($format, $offset=0) {
		return date($format, mktime(0,0,0,($this->month + $offset),$this->day,$this->year));
	} // getTime()
  
}
?>
