<?php
// $Horde: kronolith/lib/Kronolith.php,v 1.22 2001/06/10 18:39:28 chuck Exp $

define('KRONOLITH_NAME', 'Kronolith');
require_once KRONOLITH_BASE . '/lib/version.php';
require_once KRONOLITH_BASE . '/lib/Driver.php';
require_once KRONOLITH_BASE . '/lib/Event.php';

define('KRONOLITH_EVENT',  64);
define('KRONOLITH_ALARM', 128);

define('KRONOLITH_RECUR_NONE',          0);
define('KRONOLITH_RECUR_DAILY',         1);
define('KRONOLITH_RECUR_WEEKLY',        2);
define('KRONOLITH_RECUR_DAY_OF_MONTH',  3);
define('KRONOLITH_RECUR_WEEK_OF_MONTH', 4);
define('KRONOLITH_RECUR_YEARLY',        5);

define('KRONOLITH_SUNDAY',    0);
define('KRONOLITH_MONDAY',    1);
define('KRONOLITH_TUESDAY',   2);
define('KRONOLITH_WEDNESDAY', 3);
define('KRONOLITH_THURSDAY',  4);
define('KRONOLITH_FRIDAY',    5);
define('KRONOLITH_SATURDAY',  6);

define('KRONOLITH_MASK_SUNDAY',    1);
define('KRONOLITH_MASK_MONDAY',    2);
define('KRONOLITH_MASK_TUESDAY',   4);
define('KRONOLITH_MASK_WEDNESDAY', 8);
define('KRONOLITH_MASK_THURSDAY',  16);
define('KRONOLITH_MASK_FRIDAY',    32);
define('KRONOLITH_MASK_SATURDAY',  64);
define('KRONOLITH_MASK_WEEKDAYS',  62);
define('KRONOLITH_MASL_WEEKEND',   65);
define('KRONOLITH_MASK_ALLDAYS',   127);

define('KRONOLITH_JANUARY',    1);
define('KRONOLITH_FEBRUARY',   2);
define('KRONOLITH_MARCH',      3);
define('KRONOLITH_APRIL',      4);
define('KRONOLITH_MAY',        5);
define('KRONOLITH_JUNE',       6);
define('KRONOLITH_JULY',       7);
define('KRONOLITH_AUGUST',     8);
define('KRONOLITH_SEPTEMBER',  9);
define('KRONOLITH_OCTOBER',   10);
define('KRONOLITH_NOVEMBER',  11);
define('KRONOLITH_DECEMBER',  12);


/**
 * The Kronolith:: class provides the functionality common to all of
 * Kronolith.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.22 $
 * @since   Kronolith 0.1
 * @package kronolith
 */
class Kronolith {
	
    // FIXME: only works for one day right now. doh.
    function getEvents ($timestamp = null) {
	global $calendar;
	
	if (!isset($timestamp))
	  $timestamp = mktime();
	
	$times = explode('-', date('Y-n-j', $timestamp));
	$list = $calendar->listEvents(array('year'  => $times[0],
					    'month' => $times[1],
					    'day'   => $times[2]),
				      array('year'  => $times[0],
					    'month' => $times[1],
					    'day'   => $times[2]));
	
	$events = array();
	if (is_array($list)) {
	    foreach ($list as $eventID) {
		$event = $calendar->getEvent($eventID);
		
		/* sanity */
		if (!isset($event->start->hour)) $event->start->hour = 0;
		if (!isset($event->start->min)) $event->start->min = 0;
		if (!isset($event->start->sec)) $event->start->sec = 0;
		if (!isset($event->end->hour)) $event->end->hour = 0;
		if (!isset($event->end->min)) $event->end->min = 0;
		if (!isset($event->end->sec)) $event->end->sec = 0;
		
		$event->start_time = mktime($event->start->hour, $event->start->min, $event->start->sec, $times[1], $times[2], $times[0]) ;
		$event->end_time = mktime($event->end->hour, $event->end->min, $event->end->sec, $event->end->month, $event->end->mday, $event->end->year) ;;
		$events[] = $event;
	    }
	}
	return $events;
    }
    
    function secondsToString($seconds)
    {
        $hours = floor($seconds / 3600);
        $minutes = ($seconds / 60) % 60;
        
        if ($hours > 1) {
            if ($minutes == 0) {
                return sprintf(_("%d hours"), $hours);
            } else if ($minutes == 1) {
                return sprintf(_("%d hours, %d minute"), $hours, $minutes);
            } else {
                return sprintf(_("%d hours, %d minutes"), $hours, $minutes);
            }
        } else if ($hours == 1) {
            if ($minutes == 0) {
                return sprintf(_("%d hour"), $hours);
            } else if ($minutes == 1) {
                return sprintf(_("%d hour, %d minute"), $hours, $minutes);
            } else {
                return sprintf(_("%d hour, %d minutes"), $hours, $minutes);
            }
        } else {
            if ($minutes == 0) {
                return _("no time");
            } else if ($minutes == 1) {
                return sprintf(_("%d minute"), $minutes);
            } else {
                return sprintf(_("%d minutes"), $minutes);
            }
        }
    }
    
    /**
     * Returns week of the year, first Monday is first day of first week
     *
     * @param optional string $day    in format DD
     * @param optional string $month  in format MM
     * @param optional string $year   in format CCYY
     *
     * @return integer $week_number
     */
    function weekOfYear($day = null, $month = null, $year = null)
    {
        if (!isset($year)) $year = date('Y');
        if (!isset($month)) $month = date('m');
        if (!isset($day)) $day = date('d');
        
        if (function_exists('mcal_week_of_year')) {
            return mcal_week_of_year($day, $month, $year);
        } else {
            echo 'not implemented outside of mcal yet';
        }
    }
    
    /**
     * Return the number of weeks in the given year (52 or 53).
     *
     * @param optional integer $year  The year to count the number of weeks in.
     *
     * @return integer $numWeeks      The number of weeks in $year.
     */
    function weeksInYear($year = null)
    {
        if (!isset($year)) $year = date('Y');
        
        // Find the last Thursday of the year.
        $day = 31;
        while (date('w', mktime(0, 0, 0, 12, $day, $year)) != 4) {
            $day--;
        }
        return Kronolith::weekOfYear($day, 12, $year);
    }
    
    /**
     * Returns the day of the year (1-366) that corresponds to the
     * first day of the given week.
     *
     * @param int week        The week of the year to find the first day of.
     *
     * @return int dayOfYear  The day of the year of the first day of the given week.
     */
    function firstDayOfWeek($week = null, $year = null)
    {
        if (!isset($year)) $year = date('Y');
        if (!isset($week)) $week = Kronolith::weekOfYear(null, null, $year);
        
        $start = Kronolith::dayOfWeek($year, 1, 1);
        if ($start > 3) $start -= 7;
        return ((($week * 7) - (7 + $start)) + 1);
    }
    
    /**
     * Find the number of days in the given month.
     *
     * @param string month in format MM, default current local month
     *
     * @return int number of days
     */
    function daysInMonth($month = null, $year = null)
    {
        if (!isset($month)) {
            $month = date('n');
        }
        if ($month == 2) {
            if (!isset($year))
                $year = date('Y');
            
            if (Kronolith::isLeapYear($year))
                return 29;
            else
                return 28;
        } elseif ($month == 4 || $month == 6 || $month == 9 || $month == 11) {
            return 30;
        } else {
            return 31;
        }
    }
    
    function isLeapYear($year = null)
    {
        if (!isset($year)) {
            $year = date('Y');
        } else {
            if (strlen($year) != 4)
                return false;
            
            if (preg_match('/\D/', $year))
                return false;
        }
        
        return (($year % 4 == 0 && $year % 100 != 0) || $year % 400 == 0);
    }
    
    /**
     * Return the day of the week (0 = Monday, 6 = Sunday) of the
     * given date.
     *
     * @param optional int $year
     * @param optional int $month
     * @param optional int $day
     *
     * @return int The day of the week.
     */
    function dayOfWeek($year = null, $month = null, $day = null)
    {
        if (!isset($year))  $year  = date('Y');
        if (!isset($month)) $month = date('m');
        if (!isset($day))   $day   = date('d');
        
        if ($month > 2)
            $month -= 2;
        else {
            $month += 10;
            $year--;
        }
        
        $day = (floor((13 * $month - 1) / 5) +
                $day + ($year % 100) +
                floor(($year % 100) / 4) +
                floor(($year / 100) / 4) - 2 *
                floor($year / 100) + 77);
        
        $weekday_number = (($day - 7 * floor($day / 7))) - 1;
        if ($weekday_number == -1) $weekday_number = 6; // wrap check
        
        return $weekday_number;
    }
    
    function compareDates($firstYear, $firstMonth, $firstDay, $secondYear, $secondMonth, $secondDay)
    {
        $firstStamp = mktime(0, 0, 0, $firstMonth, $firstDay, $firstYear);
        $secondStamp = mktime(0, 0, 0, $secondMonth, $secondDay, $secondYear);
        
        return $firstStamp - $secondStamp;
    }
    
}
?>
