<?php
// $Horde: kronolith/lib/Event.php,v 1.4 2001/04/13 16:11:30 chuck Exp $

/**
 * Kronolith_Event:: defines a generic API for events 
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.4 $
 * @since   Kronolith 0.1
 * @package kronolith
 */
class Kronolith_Event {
    
    var $driver = null;
    var $initialized = false;
    var $id = null;
    var $title = '';
    var $category = '';
    var $location = '';
    var $description = '';
    var $keywords = array();
    var $startTimestamp = 0;
    var $endTimestamp = 0;
    var $recurEndTimestamp = 0;
    var $recurType = KRONOLITH_RECUR_NONE;
    var $recurInterval = 1;
    var $recurData = 0;
    
    function Kronolith_Event(&$driver, $eventObject = null)
    {
        $this->driver = $driver;
    }
    
    
    function isInitialized()
    {
        return $this->initialized;
    }
    
    function recurOnDay($dayMask)
    {
        return ($this->recurData & $dayMask);
    }
    
    function hasRecurType($recurrence)
    {
        return ($recurrence === $this->recurType);
    }
    
    function setRecurType($recurrence)
    {
        $this->recurType = $recurrence;
    }
    
    function setRecurInterval($interval)
    {
        $this->recurInterval = $interval;
    }
    
    function getRecurInterval()
    {
        return $this->recurInterval;
    }
    
    function setID($eventID)
    {
        $this->eventID = $eventID;
    }
    
    function getID()
    {
        return $this->eventID;
    }
    
    function setTitle($title)
    {
        $this->title = $title;
    }
    
    function getTitle()
    {
        return $this->title;
    }
    
    function setDescription($description)
    {
        $this->description = $description;
    }
    
    function getDescription()
    {
        return $this->description;
    }
    
    function setCategory($category)
    {
        $this->category = $category;
    }
    
    function getCategory()
    {
        return $this->category;
    }
    
    function setLocation($location)
    {
        $this->location = $location;
    }
    
    function getLocation()
    {
        return $this->location;
    }
    
    function setStartTimestamp($startTimestamp)
    {
        $this->startTimestamp = $startTimestamp;
    }
    
    function setKeywords($keywords)
    {
        $this->keywords = $keywords;
    }
    
    function getKeywords()
    {
        return $this->keywords;
    }
    
    function hasKeyword($keyword)
    {
        return in_array($keyword, $this->keywords);
    }

    function getStartTimestamp($dayTimestamp = null)
    {
        if (!isset($dayTimestamp))
            return $this->startTimestamp;
        
        list($year, $month, $day) = explode(':', date('Y:n:j', $dayTimestamp));
        list($hour, $min, $sec) = explode(':', date('G:i:s', $this->startTimestamp));
        
        return mktime($hour, $min, $sec, $month, $day, $year);
    }
    
    function getStartDate($formatString, $dayTimestamp = null)
    {
        return date($formatString, $this->getStartTimestamp($dayTimestamp));
    }
    
    function setEndTimestamp($endTimestamp)
    {
        $this->endTimestamp = $endTimestamp;
    }
    
    function getEndTimestamp($dayTimestamp = null)
    {
        if (!isset($dayTimestamp))
            return $this->endTimestamp;
        
        list($year, $month, $day) = explode(':', date('Y:n:j', $dayTimestamp));
        list($hour, $min, $sec) = explode(':', date('G:i:s', $this->endTimestamp));
        
        return mktime($hour, $min, $sec, $month, $day, $year);
    }
    
    function getEndDate($formatString, $dayTimestamp = null)
    {
        return date($formatString, $this->getEndTimestamp($dayTimestamp));
    }
    
    function setRecurEndTimestamp($recurTimestamp)
    {
        $this->recurEndTimestamp = $recurTimestamp;
    }
    
    function getRecurEndTimestamp()
    {
        return $this->recurEndTimestamp;
    }
    
    function getRecurEndDate($formatString)
    {
        return date($formatString, $this->recurEndTimestamp);
    }
    
}
?>
