<?php
// $Horde: kronolith/lib/Driver.php,v 1.6 2001/02/22 16:43:07 chuck Exp $

/**
 * Kronolith_Driver:: defines an API for implementing storage backends
 * for Kronolith.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.6 $
 * @since   Kronolith 0.1
 * @package kronolith
 */
class Kronolith_Driver {
    
    /**
     * Attempts to return a concrete Kronolith_Driver instance based
     * on $driver.
     * 
     * @param $driver   The type of concrete Kronolith_Driver subclass to return.
     *                  This is based on the calendar driver ($driver). The
     *                  code is dynamically included.
     *
     * @param $params   (optional) A hash containing any additional
     *                  configuration or connection parameters a subclass
     *                  might need.
     *
     * @return          The newly created concrete Kronolith_Driver instance, or false
     *                  on error.
     */
    function factory($driver, $params = array())
    {
        $driver = strtolower($driver);
        if (@include_once dirname(__FILE__) . '/Driver/' . $driver . '.php') {
            $class = 'Kronolith_Driver_' . $driver;
            return new $class($params);
        } else {
            return false;
        }
    }
    
}
?>
