<?php
// $Horde: kronolith/lib/Day.php,v 1.13 2001/06/11 20:44:42 chuck Exp $

/**
 * The Kronolith_Day:: class provides an API for dealing with days.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.13 $
 * @since   Kronolith 0.1
 * @package kronolith
 */
class Kronolith_Day {
    
    var $month;
    var $day;
    var $year;
    var $time;
    var $hours;
    
    
    function Kronolith_Day ($month = null, $day = null, $year = null, $timestamp = null) {
        if (!empty($timestamp)) {
            $this->time = $timestamp;
        } else {
            if (!isset($month)) {
                $month = date('m');
            }
            
            if (!isset($year)) {
                $year = date('Y');
            }
            
            if (!isset($day)) {
                $day = date('d');
            }
            
            // now, compensate for any wrap around
            $this->time = mktime(0,0,0,$month,$day,$year);
        }
        
        $this->month = date('m', $this->time);
        $this->year = date('Y', $this->time);
        $this->day = date('d', $this->time);
    
        // make the data array
        $this->makeHours();
    }
  
  
    function makeHours () {
        $this->hours = array();
    
        $row = 0;
        for ($i = 0; $i < 48; $i++) {
            $this->hours[$i]['timestamp'] = mktime(0, $i*30, 0, $this->month, $this->day, $this->year);
        }
    }
  
    function getTime($format, $offset = 0)
    {
        return date($format, mktime(0,0,0,$this->month,($this->day + $offset),$this->year));
    }
  
    function getTomorrow()
    {
        return mktime(0,0,0,$this->month,$this->day+1,$this->year);
    }
  
    function getStamp()
    {
        return mktime(0,0,0,$this->month,$this->day,$this->year);
    }
    
    function getDayOfWeek()
    {
        return Kronolith::dayOfWeek($this->year, $this->month, $this->day);
    }
    
    function isToday()
    {
        return (mktime(0,0,0,$this->month,$this->day,$this->year) == mktime(0,0,0));
    }
    
}
?>
