<?php
/*
 * $Horde:
 *
 * Kronolith: Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL). If you did
 * not receive such a file, see also http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
$kronolith_configured = (@is_readable(KRONOLITH_BASE . '/config/conf.php') &&
                         @is_readable(KRONOLITH_BASE . '/config/prefs.php') &&
                         @is_readable(KRONOLITH_BASE . '/config/html.php'));

if ($kronolith_configured) {
    include_once KRONOLITH_BASE . '/lib/base.php';
    
    $uri = 'month.php';
    if (!empty($HTTP_SERVER_VARS['QUERY_STRING'])) {
        $uri .= '?' . $HTTP_SERVER_VARS['QUERY_STRING'];
    }
    
    header('Location: ' . Horde::applicationUrl($uri, true));
    exit;
    
/* Kronolith isn't configured */
} else {
    // We have to guess where Horde is.
    define('HORDE_BASE', dirname(__FILE__) . '/..');
    include HORDE_BASE . '/config/horde.php';
    include_once KRONOLITH_BASE . '/lib/Kronolith.php';
    
    $title = _("Kronolith is not fully configured.");
    include KRONOLITH_BASE . '/templates/common-header.inc';
    include KRONOLITH_BASE . '/templates/index/notconfigured.inc';
    include KRONOLITH_BASE . '/templates/common-footer.inc';
}

?>
