<?php

require '../config/horde.php';
require './config/conf.php';
error_reporting($conf['debug_level']);

require_once '../lib/Horde.php';
require_once './lib/Kronolith.php';

session_name($horde['session_name']);
@session_start();

if (!isset($kronolith) || !is_array($kronolith)) {
    header('Location: ' . Horde::url('login.php', true));
    exit;
}

function date_compare ($foo, $bar) {
    $a = $foo['date'];
    $b = $bar['date'];
    
    $minx = mcal_date_compare($a->year, $a->month, $a->mday, $b->year, $b->month, $b->mday);
    if ($minx != 0) {
		return $minx;
    }
    
    if (isset($a->hour) && isset($b->hour) && ($a->hour != $b->hour)) {
		return ($a->hour >= $b->hour);
    } elseif (isset($a->min) && isset($b->min) && ($a->min != $b->min)) {
		return ($a->min >= $b->min);
    } elseif (isset($a->sec) && isset($b->sec)) {
		return ($a->sec >= $b->sec);
    } else {
        return 1;
    }
}

$title = 'Calendar';

require $conf['paths']['templates'] . '/doctype.inc';
require $conf['paths']['templates'] . '/common-header.inc';
require 'menu.php';

?>

<center>

<?php

$montharray = array('foo', 'January', 'February', 'March', 'April', 'May', 'June', 'July',
					'August', 'September', 'October', 'November', 'December');

$current_date=getdate();

if (empty($month)) $month = $current_date['mon'];
if (empty($year)) $year = $current_date['year'];

$stream = mcal_open('{/mstore}', $kronolith['user'], $kronolith['pass']);

$days = mcal_days_in_month($month, mcal_is_leap_year($year));
$startday = mcal_day_of_week($year, $month, 1) - 1; // make weeks start on monday
if ($startday == -1) $startday = 6;                 // check for wrap around

$events = mcal_list_events($stream, $year, $month, 1, $year, $month, $days);

for ($x=0; $x<count($events); $x++) {
	$event = mcal_fetch_event($stream, $events[$x]);
	if ($event->recur_type != MCAL_RECUR_NONE) {
		// we need to make sure that we only ask for recurrences inside the date range
		if (mcal_date_compare($event->start->year, $event->start->month, $event->start->mday, $year, $month, 1) < 0) {
			$mday = 1;
		} else {
		    $date_array[$event->start->mday][$event->id]['title'] = "<br>$event->title";
		    $date_array[$event->start->mday][$event->id]['date'] = $event->start;
		    $date_array[$event->start->mday][$event->id]['id'] = $event->id;
		    $mday = date('j', mktime(0,0,0,$event->start->month, $event->start->mday + 1, $event->start->year));
		}
		
		$next = mcal_next_recurrence($stream, MCAL_MONDAY, array('year' => $year, 'month' => $month, 'mday' => $mday));
		while (is_object($next) && isset($next->year) && (mcal_date_compare($next->year, $next->month, $next->mday, $year, $month, $days) <= 0)) {
		    $date_array[$next->mday][$event->id]['title'] = "<br>$event->title";
		    $date_array[$next->mday][$event->id]['date'] = $event->start;
		    $date_array[$next->mday][$event->id]['date']->mday = $next->mday;
		    $date_array[$next->mday][$event->id]['date']->month = $next->month;
		    $date_array[$next->mday][$event->id]['date']->year = $next->year;
		    $date_array[$next->mday][$event->id]['id'] = $event->id;
		    $curday = $next->mday; $curmonth = $next->month; $curyear = $next->year;
		    $next = mcal_next_recurrence($stream, MCAL_MONDAY, array('year' => $curyear, 'month' => $curmonth, 'mday' => $curday + 1));
		}
	} else {
	    // It's not a recurring event, so it must be in the date range; add it.
	    $date_array[$event->start->mday][$event->id]['title'] = "<br>$event->title";
	    $date_array[$event->start->mday][$event->id]['date'] = $event->start;
	    $date_array[$event->start->mday][$event->id]['id'] = $event->id;
	}
}

$prevstamp = mktime(0,0,0, $month-1, 1, $year);
$nextstamp = mktime(0,0,0, $month+1, 1, $year);
?>

<table border="0" cellpadding="1" cellspacing="0" width="100%">
<tr><th class="header">
<a href="<?= Horde::selfURL() ?>?month=<?= date('n', $prevstamp) ?>&year=<?= date('Y', $prevstamp) ?>"><?php Horde::pimg('prev.gif', 'border="0" alt="&lt;"') ?></a>
<?php echo $montharray[$month] . ', ' . $year ?> 
<a href="<?= Horde::selfURL() ?>?month=<?= date('n', $nextstamp) ?>&year=<?= date('Y', $nextstamp) ?>"><?php Horde::pimg('next.gif', 'border="0" alt="&gt;"') ?></a>
</td></tr>

<tr><td class="control"><table border="0" cellpadding="2" cellspacing="1" width="100%">

<tr>
<th class="item">#</th>
<th class="item"><?= _("Monday") ?></th>
<th class="item"><?= _("Tuesday") ?></th>
<th class="item"><?= _("Wednesday") ?></th>
<th class="item"><?= _("Thursday") ?></th>
<th class="item"><?= _("Friday") ?></th>
<th class="item"><?= _("Saturday") ?></th>
<th class="item"><?= _("Sunday") ?></th>
</tr>

<tr>
<th><?= mcal_week_of_year(1, $month, $year) ?></th>
<?php
for ($i=0; $i < $startday; $i++) { 
	echo '<td></td>';
}
$dayofweek = $startday;
for ($i=1; $i <= $days; $i++) {
	if (($dayofweek % 7 == 0) && ($dayofweek !=0)) {
		echo "</tr>\n<tr><th>" . mcal_week_of_year($i, $month, $year) . '</th>';
	}
	if (mktime(0,0,0) == mktime(0,0,0, $month, $i, $year)) {
		$style = 'selected';
	} elseif (isset($date_array[$i]) && is_array($date_array[$i])) {
		$style = 'item';
	} else {
		$style = 'text';
	}
	echo '<td class="' . $style . '" height="100" width="100" valign="top">';
	echo '<b><a href="' . Horde::url("day.php?month=$month&year=$year&day=$i") . "\">$i</a></b>";
	echo " <font size=\"-2\">[<a href=\"addevent.php?month=$month&year=$year&day=$i\">" . _("New") . "</a>]</font>";
	if (isset($date_array[$i]) && is_array($date_array[$i])) {
	    usort($date_array[$i], 'date_compare');
	    while (list(, $e) = each($date_array[$i])) {
            echo '<a href="' . Horde::url('editevent.php?eventID=' . $e['id'] . "&month=$month&year=$year&day=$i") . '">';
            echo $e['title'] . '</a>';
            // echo '<a href="' . Horde::url('delevent.php?eventID=' . $e['id'] . "&month=$month&year=$year&day=$i") . '">' . Horde::img('delete.gif', 'alt="' . _("Delete Event") . '"') . '</a>';
	    }
	}
	echo '</font></td>';
	$dayofweek++;
}
?>
</tr></table>
</td></tr></table>

<?php require $conf['paths']['templates'] . '/common-footer.inc'; ?>
