<?php
/*
 * $Horde: kronolith/menu.php,v 1.3 2000/08/11 22:18:00 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999, 2000 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL). If you did
 * not receive such a file, see also http://www.fsf.org/copyleft/gpl.html.
 */

// {{{ menuItem()
/**
 * Generates the HTML for an item on the menu bar.
 *
 * @param $url      String containing the value for the hyperlink.
 * @param $text     String containing the label for this menu item.
 * @param $icon     (optional) String containing the filename of the image icon
 *                  to display for this menu item.
 *
 * @return  string  String containing the HTML to display this menu item.
 */
function menuItem($url, $text, $icon = '')
{
    global $conf, $doc;

    $html = '<td align="center" valign="bottom" nobr>';
    $html .= '<a class="menuitem" href="' . $url . '" ';
    $html .= "onMouseOver=\"status='$text'; return true;\" ";
    $html .= 'onMouseOut="status=\'\';">';

    if (!empty($icon) && $conf['layout']['menu_images']) {
        $html .= Horde::img($icon, "align=\"middle\" alt=\"$text\"") . '<br>';
    }

    $html .= $text . "</a>&nbsp;</td>\n";

    return $html;
}
// }}}

// {{{ pmenuItem()
/**
 * Prints the result of the menuItem function.
 *
 * @param $url      String containing the value for the hyperlink.
 * @param $text     String containing the label for this menu item.
 * @param $icon     (optional) String containing the filename of the image icon
 *                  to display for this menu item.
 */
function pmenuItem($url, $text, $icon = '')
{
    echo menuItem($url, $text, $icon);
}
// }}}

// {{{ configMenuItem
/**
 * Parses a line of text in the form:
 *
 *      url<label>icon
 *
 * ... and passes the components to the menuItem function.
 *
 * @param $text     String containing a line of text representing a menu item.
 *
 * @return  string  The resulting HTML to display the menu item.
 */
function configMenuItem($text)
{
    global $conf, $doc;

    /* Skip any comment lines. */
    if (preg_match("|([^#]*)#.*|", $text, $regs)) {
        $text = $regs[1];

        /* Salvage anything before the comment. */
        if (strlen($text) > 0) {
            $text = $text . "\n";
        }
    }

    if (stristr($text, '<separator>')) {
        $text = '<td>&nbsp;</td>';
    } elseif (preg_match("|(.*)<(.*)>(.*)\n|", $text, $regs)) {
        $text = menuItem($regs[1], $regs[2], $regs[3]);
    }

    return $text;
}
// }}}

/* Check for additional site-specific menu items (in config/menu.txt). */
$additional_items = '';
$items = @file('./config/menu.txt');
if (is_array($items)) {
    foreach ($items as $item) {
        $additional_items .= configMenuItem($item);
    }
}

include $conf['paths']['templates'] . '/menu/menu.inc';

?>
