<?php
// $Horde: kronolith/lib/dayView.php,v 1.25 2000/08/29 02:24:32 chuck Exp $

require_once './lib/day.php';
		
class Kronolith_dayView {
  
	var $Day;
	var $Cal;
	var $event_arr;
	var $parsed = false;
	var $lines;
	var $lncount;
	var $columns;
	
	
	function Kronolith_dayView ($month='', $day='', $year='') {
		// FIXME: no globals
		global $stream;
		
		$this->Day = new Kronolith_day($month, $day, $year);
		$this->event_arr = Kronolith::getEvents($stream, $this->Day->getStamp());
		$this->lines = array();
		$this->lncount = array();
		$this->colors = array('#ffcccc', '#ccccff', '#ccffcc', '#ccffff', '#ffffcc', '#ccffff', '#ffccff', '#cccccc');
	} // Constructor
	
	
	function html ($template_path = './templates') {
		if (!$this->parsed)
			$this->parse();
		$hours = $this->Day->hours;
		$current_arr = array();
		$started = false;
		
		include $template_path . '/day/head.inc';
		for ($i=0; $i<count($hours); $i++) {
			if (!$started && !isset($this->lines[$i]) && $i<12)
				continue;
			
			$started = true;
			$row = '';
			$hspan = 0;
			$row_set = false;
			$current = 0;
			$time = date('g:ia', $hours[$i]['timestamp']);
			$style = (floor($i/2) % 2) ? 'item1' : 'item0';
      
			if (count($current_arr) > 0) {
				reset($current_arr);
				while (list($id, $event) = each($current_arr)) {
					if (is_object($event)) {
						$event->span = $event->span - 1;
						if ($event->span == 0) {
							$current_arr[$id] = '';
							unset($current_arr[$id]);
						} else {
							$current++;
							if ($event->overlap > $hspan)
								$hspan = $event->overlap;
							$current_arr[$id] = $event;
						}
					}
				}
				if ($current > 0) {
					$row_set = true;
				}
			}
      
			if (isset($this->lines[$i]) && is_array($this->lines[$i])) {
				while (list(,$key) = each($this->lines[$i])) {
					$event = $this->event_arr[$key];
					if ($event->overlap > $hspan)
						$hspan = $event->overlap;
					$row .= '<td valign="top" width="100%" colspan="' . ($this->columns / $event->overlap) . '" rowspan="' . $event->span
						. '" bgcolor="' . $this->colors[($event->color % count($this->colors))] . '"><font size="2" face="geneva,arial,helvetica,sans-serif">'
						. '<a href="' . Horde::url("editevent.php?eventID=$event->id&timestamp=" . $this->Day->getStamp()) . '">' . $event->title . '</a>'
						. '<a href="' . Horde::url("delevent.php?eventID=$event->id&timestamp=" . $this->Day->getStamp()) . '"><img src="graphics/delete.gif" alt="delete" border=0 hspace=2 vspace=0></a></font></td>' . "\n";
					$row_set = true;
					$current++;
					$current_arr[$event->id] = $event;
				}
			}
      
			while ($current < $hspan) {
				$row .= '<td width="100%" colspan="' . ($this->columns / $hspan) . '" class="' . $style . '"><font size="2">&nbsp;</font></td>' . "\n";
				$current++;
			}
      
			if (!$row_set) {
				$row = '<td width="100%" colspan="' . $this->columns . '" class="' . $style . '"><font size="2">&nbsp;</font></td>' . "\n";
			}
      
			if ($i % 2) {
				include $template_path . '/day/row_half.inc';
			} else {
				include $template_path . '/day/row.inc';
			}
		}
		include $template_path . '/day/foot.inc';
	}
	// }}}
  
	// This function runs through the events and tries to figure out
	// what should be on each line of the outputted table. This could
	// get complex...
	function parse () {
		for ($i=0; $i<48; $i++)
			$this->lncount[$i] = 0;
    
		$base = $this->Day->getStamp();
		$top = $this->Day->getTomorrow();
		$color = 0;
		while (list($key, $event) = each($this->event_arr)) {
			// need to recompute these to make sure they're for the current day for repeating events
			$start_arr = explode(':', date('G:i', $event->start_time));
			$stop_arr = explode(':', date('G:i', $event->end_time));
			$start_time = mktime($start_arr[0], $start_arr[1], 0, $this->Day->month, $this->Day->day, $this->Day->year);
			$end_time = mktime($stop_arr[0], $stop_arr[1], 0, $this->Day->month, $this->Day->day, $this->Day->year);
			
			if ($start_time < $base) {
				$lower = 0;
			} else {
				$lower = floor(($start_time - $base)/1800);
			}
      
			// since we generate end_time for today, we need to check to see if it's less than start time, indicating wrap-around
			// NOTE: this will break events longer than 24 hours...
			if ($end_time >= $top || $end_time <= $start_time) {
				$upper = 47;
			} else {
				$upper = floor(($end_time - $base - 1)/1800);
			}
      
			$event->span = $upper - $lower + 1;
			$event->lower = $lower;
			$event->upper = $upper;
			$event->color = $color;
			$event->key = $key;
			$event->overlap = 1; // number of events in this event's row. will be updated later.
			$event->overlapping = array();
			$this->lines[$lower][] = $key;
			for ($j=$lower; $j < ($event->span+$lower); $j++) {
				if (isset($this->lnevents[$j]) && is_array($this->lnevents[$j])) {
					reset($this->lnevents[$j]);
					while (list(,$evkey) = each($this->lnevents[$j])) {
						$lnevent = $this->event_arr[$evkey];
						if (!isset($lnevent->overlapping[$key])) {
							$lnevent->overlapping[$key] = $key;
							$this->event_arr[$evkey] = $lnevent;
						}
						if (!isset($event->overlapping[$evkey])) {
							$event->overlapping[$evkey] = $evkey;
						}
					}
				}
				$this->lnevents[$j][] = $key;
				$this->lncount[$j]++;
			}
			$this->event_arr[$key] = $event;
			$color++;
		}
    
		// loop through the events and determine how many they "uniqely overlap" with
		reset($this->event_arr);
		while (list($key, $event) = each($this->event_arr)) {
			$counted = array();
			$oevents = $event->overlapping;
			$at_least_two = false;
			while (count($oevents) > 0) {
				$cevent = $this->event_arr[array_pop($oevents)];
				$match = 0;
				$at_least_two = true;
				while (list(,$devkey) = each($oevents)) {
					$devent = $this->event_arr[$devkey];
					if ($cevent->upper >= $devent->lower && $cevent->lower <= $devent->upper && $cevent->key != $devent->key) {
						if (!isset($counted[$cevent->key])) {
							$match++;
							$counted[$cevent->key] = 1;
						}
						if (!isset($counted[$devent->key])) {
							$match++;
							$counted[$devent->key] = 1;
						}
					}
					$counted[$cevent->key] = 1;
				}
				$event->overlap += $match;
			}
			if ($at_least_two && $event->overlap == 1)
				$event->overlap++;
			$this->event_arr[$key] = $event;
		}
    
		// figure out how many total columns are needed
		$lnevents = array();
		$this->columns = 1;
		$even = 1; // this makes sense, really
		for ($i=0; $i<48; $i++) {
			if ($this->lncount[$i] % 2) { // odd
				$this->columns = $this->columns * $this->lncount[$i];
			} else { // even
				if ($this->lncount[$i] > $even)
					$even = $this->lncount[$i];
			}
		}
		$this->columns = $this->columns * $even;
    
		$this->parsed = true;
	}
	// }}}
  
	function link ($offset=0) {
		return 'day.php?month=' . $this->Day->getTime('n', $offset) . '&day=' . $this->Day->getTime('j', $offset) . '&year=' . $this->Day->getTime('Y', $offset);
	}
	// }}}
  
}

?>
