<?php
// $Horde: kronolith/lib/day.php,v 1.7 2000/08/16 19:20:25 jon Exp $

class Kronolith_day {
  
  var $month;
  var $day;
  var $year;
  var $time;
  var $hours;
  
  
  function Kronolith_day ($month='', $day='', $year='') {
    if ($month == '') {
      $month = date('m');
    }
    
    if ($year == '') {
      $year = date('Y');
    }
    
    if ($day == '') {
      $day = date('d');
    }
    
    // now, compensate for any wrap around
    $this->time = mktime(0,0,0,$month,$day,$year);
    $this->month = date('m', $this->time);
    $this->year = date('Y', $this->time);
    $this->day = date('d', $this->time);
    
    // make the data array
    $this->makeHours();
  } // Constructor
  
  
  function makeHours () {
    $this->hours = array();
    
    $row = 0;
    for ($i = 0; $i < 48; $i++) {
      $this->hours[$i]['timestamp'] = mktime(0, $i*30, 0, $this->month, $this->day, $this->year);
    }
  } // makeHours()
  
  function getTime ($format, $offset=0) {
    return date($format, mktime(0,0,0,$this->month,($this->day + $offset),$this->year));
  } // getTime()
  
  function getTomorrow () {
    return mktime(0,0,0,$this->month,$this->day+1,$this->year);
  } // getTomorrow()
  
  function getStamp () {
    return mktime(0,0,0,$this->month,$this->day,$this->year);
  } // getStamp()
  
}

?>
