<?php

require '../config/horde.php';
require './config/conf.php';
error_reporting($conf['debug_level']);

require_once '../lib/Horde.php';
require_once './lib/Kronolith.php';

session_name($horde['session_name']);
@session_start();

if (!isset($kronolith) || !is_array($kronolith)) {
	header('Location: ' . Horde::url('login.php', true));
	exit;
}

require './config/conf.php';

$stream = mcal_open('{/mstore}', $kronolith['user'], $kronolith['pass']);
$event = mcal_fetch_event($stream, $eventID);

// basic fields
if (isset($title)) mcal_event_set_title($stream, $title);
if (isset($description)) mcal_event_set_description($stream, $description);
if (isset($category)) mcal_event_set_category($stream, $category);

// event start
if (isset($start_year) && isset($start_month) && isset($start_day) && isset($start_hour) && isset($start_min) && isset($am_pm)) {
    if ($am_pm == 'PM') {
        if ($start_hour != 12)
            $start_hour += 12;
    } elseif ($start_hour == 12) {
        $start_hour = 0;
    }
	mcal_event_set_start($stream, $start_year, $start_month, $start_day, $start_hour, $start_min);
    
	// event_end
	if (isset($end_hour) && isset($end_min)) {
		$endstamp = mktime($start_hour + $end_hour, $start_min + $end_min, 0, $start_month, $start_day, $start_year);
		$end = explode(':', date('Y:n:j:G:i', $endstamp));
		mcal_event_set_end($stream, $end[0], $end[1], $end[2], $end[3], $end[4]);
	}
}

// recurrence
if (isset($recur)) {
	switch ($recur) {
	case MCAL_RECUR_NONE:
		mcal_event_set_recur_none($stream);
		break;
    
	case MCAL_RECUR_DAILY:
		if (isset($recur_enddate_year) && isset($recur_enddate_month) && isset($recur_enddate_day))
			mcal_event_set_recur_daily($stream, $recur_enddate_year, $recur_enddate_month, $recur_enddate_day, 1);
		break;

	case MCAL_RECUR_WEEKLY:
		if (isset($recur_enddate_year) && isset($recur_enddate_month) && isset($recur_enddate_day) && isset($weekly) && is_array($weekly)) {
			$weekdays = 0;
			while (list(,$day) = each($weekly))
				$weekdays |= $day;
			mcal_event_set_recur_weekly($stream, $recur_enddate_year, $recur_enddate_month, $recur_enddate_day, 1, $weekdays);
		}
		break;
    
	case MCAL_RECUR_MONTHLY_MDAY:
		break;
    
	case MCAL_RECUR_YEARLY:
		if (isset($recur_enddate_year) && isset($recur_enddate_month) && isset($recur_enddate_day))
			mcal_event_set_recur_yearly($stream, $recur_enddate_year, $recur_enddate_month, $recur_enddate_day, 1);
		break;
    
	} // switch()
} // if()

// store
mcal_store_event($stream);

// get out of here
header('Location: ' . Horde::url("month.php?month=$month&year=$year", true));

?>
