<?php
/**
 * $Horde: ingo/filters.php,v 1.59 2004/12/20 04:06:26 chuck Exp $
 *
 * Copyright 2002-2004 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file LICENSE for license information. If you
 * did not receive this file, see http://www.horde.org/licenses.
 */

@define('INGO_BASE', dirname(__FILE__));
require_once INGO_BASE . '/lib/base.php';
require_once 'Horde/Template.php';

/* Get the list of filter rules. */
$filters = $ingo_storage->retrieve(INGO_STORAGE_ACTION_FILTERS);

/* Load the Ingo_Script:: driver. */
$ingo_script = &Ingo::loadIngoScript();

/* Determine if we need to show the on-demand settings. */
$on_demand = $ingo_script->performAvailable();

/* Get web parameter data. */
$actionID = Util::getFormData('actionID');
$id = Util::getFormData('rulenumber');

/* Perform requested actions. */
switch ($actionID) {
case 'rule_down':
case 'rule_up':
case 'rule_copy':
case 'rule_delete':
case 'rule_disable':
case 'rule_enable':
    switch ($actionID) {
    case 'rule_delete':
        if ($filters->deleteRule($id)) {
            $notification->push(_("Rule Deleted"), 'horde.success');
        }
        break;

    case 'rule_copy':
        if ($filters->copyRule($id)) {
            $notification->push(_("Rule Copied"), 'horde.success');
        }
        break;

    case 'rule_up':
        $filters->ruleUp($id);
        break;

    case 'rule_down':
        $filters->ruleDown($id);
        break;

    case 'rule_disable':
        $filters->ruleDisable($id);
        $notification->push(_("Rule Disabled"), 'horde.success');
        break;

    case 'rule_enable':
        $filters->ruleEnable($id);
        $notification->push(_("Rule Enabled"), 'horde.success');
        break;
    }

    /* Save changes */
    $ingo_storage->store($filters);
    if ($prefs->getValue('auto_update')) {
        Ingo::updateScript();
    }
    break;

case 'settings_save':
    $prefs->setValue('show_filter_msg', Util::getFormData('show_filter_msg'));
    $prefs->setValue('filter_seen', Util::getFormData('filter_seen'));
    $notification->push(_("Settings successfully updated."), 'horde.success');
    break;

case 'apply_filters':
    if ($ingo_script->canApply()) {
        $ingo_script->apply();
    }
    break;
}

/* Get the list of rules now. */
$filter_list = $filters->getFilterList();

Horde::addScriptFile('tooltip.js', 'horde', true);
$title = _("Filter Rules");
require INGO_TEMPLATES . '/common-header.inc';
require INGO_TEMPLATES . '/menu.inc';
require INGO_TEMPLATES . '/filters/header.inc';

if (count($filter_list) == 0) {
    require INGO_TEMPLATES . '/filters/filter-none.inc';
} else {
    $display = array();
    $i = 0;
    $rule_count = array_sum(array_map(create_function('$a', "return (in_array(\$a['action'], \$_SESSION['ingo']['script_categories'])) ? 1 : 0;"), $filter_list));

    /* Common URLs. */
    $filters_url = Horde::applicationUrl('filters.php');
    $rule_url = Horde::applicationUrl('rule.php');

    /* Common graphics. */
    $down_img = Horde::img('nav/down.png', _("Move Rule Down"), '', $registry->getImageDir('horde'));
    $up_img = Horde::img('nav/up.png', _("Move Rule Up"), '', $registry->getImageDir('horde'));

    foreach ($filter_list as $rule_number => $filter) {
        /* Skip non-display categories. */
        if (!in_array($filter['action'], $_SESSION['ingo']['script_categories'])) {
            continue;
        }

        $entry = array();
        $url = Util::addParameter($filters_url, 'rulenumber', $rule_number);
        $copyurl = $delurl = $editurl = $name = null;

        switch ($filter['action']) {
        case INGO_STORAGE_ACTION_BLACKLIST:
            $editurl = Horde::applicationUrl('blacklist.php');
            $entry['filterimg'] = Horde::img('blacklist.png');
            $name = _("Blacklist");
            break;

        case INGO_STORAGE_ACTION_WHITELIST:
            $editurl = Horde::applicationUrl('whitelist.php');
            $entry['filterimg'] = Horde::img('whitelist.png');
            $name = _("Whitelist");
            break;

        case INGO_STORAGE_ACTION_VACATION:
            $editurl = Horde::applicationUrl('vacation.php');
            $entry['filterimg'] = Horde::img('vacation.png');
            $name = _("Vacation");
            break;

        case INGO_STORAGE_ACTION_FORWARD:
            $editurl = Horde::applicationUrl('forward.php');
            $entry['filterimg'] = Horde::img('forward.png');
            $name = _("Forward");
            break;

        default:
            $editurl = Util::addParameter($rule_url, array('edit' => $rule_number, 'actionID' => 'rule_edit'));
            $delurl  = Util::addParameter($url, 'actionID', 'rule_delete');
            $copyurl = Util::addParameter($url, 'actionID', 'rule_copy');
            $entry['filterimg'] = false;
            $name = $filter['name'];
            break;
        }

        /* Create description. */
        if (!empty($filter['conditions'])) {
            $descrip = '';
            $condition_size = count($filter['conditions']) - 1;
            foreach ($filter['conditions'] as $condid => $cond) {

                $descrip .= sprintf("%s %s \"%s\"", _($cond['field']), _($cond['match']), $cond['value']);
                if (!empty($cond['case'])) {
                    $descrip .= ' [' . _("Case Sensitive") . ']';
                }
                if ($condid < $condition_size) {
                    $descrip .= ($filter['combine'] == INGO_STORAGE_COMBINE_ALL) ? _(" and") : _(" or");
                    $descrip .= "\n  ";
                }
            }

            $descrip .= "\n";

            $ob = $ingo_storage->getActionInfo($filter['action']);
            $descrip .= $ob->label;

            if ($filter['action-value']) {
                $descrip .= ': ' . $filter['action-value'];
            }

            if ($filter['stop']) {
                $descrip .= "\n[stop]";
            }

            $entry['descriplink'] = Horde::linkTooltip($editurl, sprintf(_("Edit %s"), $name), null, null, null, $descrip) . $name;
        } else {
            $entry['descriplink'] = Horde::link($editurl, sprintf(_("Edit %s"), $name)) . $name;
        }

        /* Create edit link. */
        $entry['editlink'] = Horde::link($editurl, sprintf(_("Edit %s"), $name));
        $entry['editimg'] = Horde::img('edit.png', sprintf(_("Edit %s"), $name), '', $registry->getImageDir('horde'));

        /* Create delete link. */
        if (!is_null($delurl)) {
            $entry['dellink'] = Horde::link($delurl, sprintf(_("Delete %s"), $name), null, null, "return window.confirm('" . addslashes(_("Are you sure you want to delete this rule?")) . "');");
            $entry['delimg'] = Horde::img('delete.png', sprintf(_("Delete %s"), $name), '', $registry->getImageDir('horde'));
        } else {
            $entry['dellink'] = false;
        }

        /* Create copy link. */
        if (!is_null($copyurl)) {
            $entry['copylink'] = Horde::link($copyurl, sprintf(_("Copy %s"), $name));
            $entry['copyimg'] = Horde::img('copy.png', sprintf(_("Copy %s"), $name));
        } else {
            $entry['copylink'] = false;
        }

        /* Alternate item classes for easier reading. */
        $entry['item'] = 'item' . ($i++ % 2);

        /* Create up/down arrow links. */
        $entry['uplink'] = ($i > 1) ? Horde::link(Util::addParameter($url, 'actionID', 'rule_up'), _("Move Rule Up")) : false;
        $entry['downlink'] = ($i < $rule_count) ? Horde::link(Util::addParameter($url, 'actionID', 'rule_down'), _("Move Rule Down")) : false;

        if (empty($filter['disable'])) {
            $entry['disablelink'] = Horde::link(Util::addParameter($url, 'actionID', 'rule_disable'), sprintf(_("Disable %s"), $name));
            $entry['disableimg'] = Horde::img('enable.png', sprintf(_("Disable %s"), $name));
            $entry['enablelink'] = false;
        } else {
            $entry['enablelink'] = Horde::link(Util::addParameter($url, 'actionID', 'rule_enable'), sprintf(_("Enable %s"), $name));
            $entry['enableimg'] = Horde::img('disable.png', sprintf(_("Enable %s"), $name));
            $entry['disablelink'] = false;
        }

        $display[] = $entry;
    }

    /* Output the template. */
    $template = &new Horde_Template();
    $template->set('down_img', $down_img);
    $template->set('up_img', $up_img);
    $template->set('filter', $display, true);
    $template->setOption('gettext', true);
    echo $template->fetch(INGO_TEMPLATES . '/filters/filter.html');
}

require INGO_TEMPLATES . '/filters/footer.inc';
if ($on_demand) {
    require INGO_TEMPLATES . '/filters/settings.inc';
}

require $registry->get('templates', 'horde') . '/common-footer.inc';
