<?php
/**
 * Ingo_Storage_prefs:: implements the Ingo_Storage:: API to save Ingo data
 * via the Horde preferences system.
 *
 * $Horde: ingo/lib/Storage/prefs.php,v 1.14 2004/01/10 16:55:48 chuck Exp $
 *
 * See the enclosed file LICENSE for license information. If you
 * did not receive this file, see http://www.horde.org/licenses.
 *
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.14 $
 * @since   Ingo 0.1
 * @package Ingo
 */
class Ingo_Storage_prefs extends Ingo_Storage {

    /**
     * Constructor.
     *
     * @access public
     *
     * @param optional array $params  Additional parameters for the subclass.
     */
    function Ingo_Storage_prefs($params = array())
    {
        $this->_params = $params;
    }

    /**
     * Retrieve the specified data.
     *
     * @access private
     *
     * @param integer $field  The constant identifierfield of the desired data.
     *
     * @return array  The specified data.
     */
    function _retrieve($field)
    {
        switch ($field) {
        case INGO_STORAGE_ACTION_BLACKLIST:
            $data = unserialize($this->_getValue('blacklist'));
            $ob = &new Ingo_Storage_blacklist();
            $ob->setBlacklist($data['a'], false);
            $ob->setBlacklistFolder($data['f']);
            return $ob;

        case INGO_STORAGE_ACTION_FILTERS:
            $data = unserialize($this->_getValue('rules'));
            $ob = &new Ingo_Storage_filters();
            $ob->setFilterlist($data);
            return $ob;

        case INGO_STORAGE_ACTION_FORWARD:
            $data = unserialize($this->_getValue('forward'));
            $ob = &new Ingo_Storage_forward();
            $ob->setForwardAddresses($data['a'], false);
            $ob->setForwardKeep($data['k']);
            return $ob;
            break;

        case INGO_STORAGE_ACTION_VACATION:
            $data = unserialize($this->_getValue('vacation'));
            $ob = &new Ingo_Storage_vacation();
            $ob->setVacationAddresses($data['addresses'], false);
            $ob->setVacationDays($data['days']);
            $ob->setVacationExcludes($data['excludes'], false);
            $ob->setVacationIgnorelist($data['ignorelist']);
            $ob->setVacationReason($data['reason']);
            $ob->setVacationSubject($data['subject']);
            return $ob;
            break;

        case INGO_STORAGE_ACTION_WHITELIST:
            $ob = &new Ingo_Storage_whitelist();
            $ob->setWhitelist(unserialize($this->_getValue('whitelist')), false);
            return $ob;
            break;

        default:
            return false;
            break;
        }
    }

    /**
     * Store the specified data.
     *
     * @access private
     *
     * @param string $ob  The object to store.
     *
     * @return boolean  True on success.
     */
    function _store($ob)
    {
        switch ($ob->obType()) {
        case INGO_STORAGE_ACTION_BLACKLIST:
            $data = array();
            $data['a'] = $ob->getBlacklist();
            $data['f'] = $ob->getBlacklistFolder();
            $ret = $this->_setValue('blacklist', serialize($data));
            break;

        case INGO_STORAGE_ACTION_FILTERS:
            $ret = $this->_setValue('rules', serialize($ob->getFilterlist()));
            break;

        case INGO_STORAGE_ACTION_FORWARD:
            $data = array();
            $data['a'] = $ob->getForwardAddresses();
            $data['k'] = $ob->getForwardKeep();
            $ret = $this->_setValue('forward', serialize($data));
            break;

        case INGO_STORAGE_ACTION_VACATION:
            $data = array();
            $data['addresses'] = $ob->getVacationAddresses();
            $data['days'] = $ob->getVacationDays();
            $data['excludes'] = $ob->getVacationExcludes();
            $data['ignorelist'] = $ob->getVacationIgnorelist();
            $data['reason'] = $ob->getVacationReason();
            $data['subject'] = $ob->getVacationSubject();
            $ret = $this->_setValue('vacation', serialize($data));
            break;

        case INGO_STORAGE_ACTION_WHITELIST:
            $ret = $this->_setValue('whitelist', serialize($ob->getWhitelist()));
            break;

        default:
            $ret = false;
            break;
        }

        return $ret;
    }

    /**
     * Get the data from the preferences backend.
     *
     * @access private
     */
    function _getValue($field)
    {
        global $prefs;
        return $prefs->getValue($field);
    }

    /**
     * Stores the data in the preferences backend.
     *
     * @access private
     */
    function _setValue($field, $data)
    {
        global $prefs;
        return $prefs->setValue($field, $data);
    }

}
