<?php
/**
 * Ingo_Driver_vfs:: Implements an Ingo storage driver using Horde VFS.
 *
 * Copyright 2003-2004 Brent J. Nordquist <bjn@horde.org>
 *
 * See the enclosed file LICENSE for license information. If you
 * did not receive this file, see http://www.horde.org/licenses.
 *
 * $Horde: ingo/lib/Driver/vfs.php,v 1.12 2004/05/20 15:48:48 jan Exp $
 *
 * @author  Brent J. Nordquist <bjn@horde.org>
 * @version $Revision: 1.12 $
 * @since   Ingo 0.1
 * @package Ingo
 */
class Ingo_Driver_vfs extends Ingo_Driver {

    /**
     * Constructs a new VFS-based storage driver.
     *
     * @access public
     *
     * @param array $params  A hash containing driver parameters.
     */
    function Ingo_Driver_vfs($params = array())
    {
        $default_params = array(
            'hostspec'    =>  'localhost',
            'port'        =>  21,
            'procmailrc'  =>  '.procmailrc',
            'vfstype'     =>  'ftp'
        );
        $this->_params = array_merge($default_params, $params);
    }

    /**
     * Sets a script running on the backend.
     *
     * @param string $script  The filter script
     *
     * @return mixed  True on success, or PEAR_Error on failure.
     */
    function setScriptActive($script, $username, $password)
    {
        if ($this->_params['vfstype'] != 'ftp') {
            return PEAR::raiseError(_(sprintf("VFS type '%s' not yet implemented.", $this->_params['vfstype'])));
        }
        $this->_params['username'] = $username;
        $this->_params['password'] = $password;

        require_once 'VFS.php';
        $vfs = &VFS::singleton($this->_params['vfstype'], $this->_params);
        $res = $vfs->writeData('', $this->_params['procmailrc'], $script);
        $vfs->_disconnect();
        if (is_a($res, 'PEAR_Error')) {
            return $res;
        }
        return true;
    }

    /**
     * Returns the content of the currently active script.
     *
     * @param string $username  The backend username.
     * @param string $password  The backend password.
     *
     * @return string  The complete ruleset of the specified user.
     */
    function getScript($username, $password)
    {
        if ($this->_params['vfstype'] != 'ftp') {
            return PEAR::raiseError(_(sprintf("VFS type '%s' not yet implemented.", $this->_params['vfstype'])));
        }
        $this->_params['username'] = $username;
        $this->_params['password'] = $password;

        require_once 'VFS.php';
        $vfs = &VFS::singleton($this->_params['vfstype'], $this->_params);
        $res = $vfs->read('', $this->_params['procmailrc']);
        $vfs->_disconnect();
        return $res;
    }

}
