<?php
/**
 * $Horde: ingo/forward.php,v 1.11 2004/11/17 03:43:53 chuck Exp $
 *
 * Copyright 2003-2004 Todd Merritt <tmerritt@email.arizona.edu>
 *
 * See the enclosed file LICENSE for license information. If you
 * did not receive this file, see http://www.horde.org/licenses.
 */

@define('INGO_BASE',  dirname(__FILE__));
require_once INGO_BASE . '/lib/base.php';

/* Redirect if forward is not available. */
if (!in_array(INGO_STORAGE_ACTION_FORWARD, $_SESSION['ingo']['script_categories'])) {
    $notification->push(_("Forward is not supported in the current filtering driver."), 'horde.error');
    header('Location: ' . Horde::applicationUrl('filters.php', true));
    exit;
}

/* Get the forward object. */
$forward = $ingo_storage->retrieve(INGO_STORAGE_ACTION_FORWARD);

/* Perform requested actions. */
$actionID = Util::getFormData('actionID');
switch ($actionID) {
case 'update':
    $forward->setForwardAddresses(Util::getFormData('addresses'));
    $forward->setForwardKeep((intval(Util::getFormData('keep_copy')) == 1));
    if (!$ingo_storage->store($forward)) {
        $notification->push("Error saving changes.", 'horde.error');
    } else {
        $notification->push(_("Changes saved."), 'horde.success');
    }

    if ($prefs->getValue('auto_update')) {
        Ingo::updateScript();
    }
    break;
}

/* Get the forward rule. */
$filters = $ingo_storage->retrieve(INGO_STORAGE_ACTION_FILTERS);
$fwd_rule = $filters->findRule(INGO_STORAGE_ACTION_FORWARD);

$title = _("Forwards Edit");
require INGO_TEMPLATES . '/common-header.inc';
require INGO_TEMPLATES . '/menu.inc';
require INGO_TEMPLATES . '/forward/forward.inc';
require $registry->get('templates', 'horde') . '/common-footer.inc';
