<?php
/**
 * IMP external API interface.
 *
 * This file defines IMP's external API interface. Other applications
 * can interact with IMP through this API.
 *
 * $Horde: imp/lib/api.php,v 1.94 2004/08/31 14:21:40 chuck Exp $
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @package IMP
 */

$_services['authenticate'] = array(
    'args' => array('userID', 'credentials', 'params'),
    'type' => 'boolean'
);

$_services['getStream'] = array(
    'args' => array('mailbox', 'flags'),
    'type' => 'resource'
);

$_services['compose'] = array(
    'args' => array('args', 'extra'),
    'type' => 'string'
);

$_services['folderlist'] = array(
    'args' => array(),
    'type' => 'stringArray'
);

$_services['createFolder'] = array(
    'args' => array('folder'),
    'type' => 'string'
);

if (!empty($_SESSION['imp']['admin'])) {
    $_services['userList'] = array(
        'type' => 'stringArray'
    );

    $_services['addUser'] = array(
        'args' => array('userId', 'credentials')
    );

    $_services['removeUser'] = array(
        'args' => array('userId', 'credentials')
    );
}


/**
 * TODO
 *
 * @param string $userID       TODO
 * @param array  $credentials  TODO
 * @param array  $params       TODO
 *
 * @return boolean  Whether IMP authentication was successful.
 */
function _imp_authenticate($userID, $credentials, $params)
{
    $authentication = 'none';
    require_once dirname(__FILE__) . '/base.php';

    if (!empty($params['server'])) {
        $server = $params['server'];
    } else {
        require_once IMP_BASE . '/config/servers.php';
        foreach ($servers as $key => $curServer) {
            if (!isset($server) && substr($key, 0, 1) != '_') {
                $server = $key;
            }
            if (IMP::isPreferredServer($curServer, $key)) {
                $server = $key;
                break;
            }
        }
    }

    require_once IMP_BASE . '/lib/Session.php';
    if (IMP_Session::createSession($userID, $credentials['password'], $server)) {
        global $imp;
        $entry = sprintf('Login success for %s [%s] to {%s:%s}', $imp['uniquser'], $_SERVER['REMOTE_ADDR'], $imp['server'], $imp['port']);
        Horde::logMessage($entry, __FILE__, __LINE__, PEAR_LOG_NOTICE);
        return true;
    }

    return false;
}

/**
 * Attempt to authenticate via IMP and return an IMAP stream.
 *
 * @param optional string $mailbox  The mailbox name.
 * @param optional integet $flags   IMAP connection flags.
 *
 * @return mixed  An IMAP resource on success, false on failure.
 */
function _imp_getStream($mailbox = null, $flags = 0)
{
    $authentication = 'none';
    require_once dirname(__FILE__) . '/base.php';

    if (IMP::checkAuthentication(OP_HALFOPEN, true) === true) {
        require_once IMP_BASE . '/lib/IMAP.php';
        $imap = &IMP_IMAP::singleton();
        if ($imap->changeMbox($mailbox, $flags)) {
            return $_SESSION['imp']['stream'];
        }
    }

    return false;
}

/**
 * Return a compose window link.
 *
 * @param optional mixed $args   List of arguments to pass to compose.php.
 *                               If this is passed in as a string, it will
 *                               be parsed as a
 *                               toaddress?subject=foo&cc=ccaddress
 *                               (mailto-style) string.
 * @param optional array $extra  Hash of extra, non-standard arguments to
 *                               pass to compose.php.
 *
 * @return string  The link to the message composition screen.
 */
function _imp_compose($args = array(), $extra = array())
{
    global $prefs;

    $authentication = 'none';
    require_once dirname(__FILE__) . '/base.php';

    return IMP::composeLink($args, $extra);
}

/**
 * Returns the list of folders.
 *
 * @return array  The list of IMAP folders.
 */
function _imp_folderlist()
{
    $authentication = 'none';
    require_once dirname(__FILE__) . '/base.php';

    $result = false;

    if (IMP::checkAuthentication(OP_HALFOPEN, true) === true) {
        if ($_SESSION['imp']['base_protocol'] == 'pop3') {
            
            $result = array('INBOX' => array('val' => 'INBOX', 'label' => 'INBOX', 'abbrev' => 'INBOX'));
        } else {
            require_once IMP_BASE . '/lib/Folder.php';
            $imp_folder = &IMP_Folder::singleton();
            $result = $imp_folder->flist_IMP();
        }
    }

    return $result;
}

/**
 * Creates a new folder.
 *
 * @return string  The full folder name created on success, an empty string
 *                 on failure.
 */
function _imp_createFolder($folder)
{
    $authentication = 'none';
    require_once dirname(__FILE__) . '/base.php';
    require_once IMP_BASE . '/lib/Folder.php';

    $foldername = IMP::addPreambleString($folder);
    $result = false;

    if (IMP::checkAuthentication(OP_HALFOPEN, true) === true) {
        $imp_folder = &IMP_Folder::singleton();
        $result = $imp_folder->create($_SESSION['imp']['stream'],
                                      $foldername,
                                      $GLOBALS['prefs']->getValue('subscribe'));
    }

    return (empty($result)) ? '' : $foldername;
}

/**
 * Add a set of authentication credentials.
 *
 * @param string $userId       The userId to add.
 * @param array  $credentials  The credentials to use.
 *
 * @return mixed  True on success or a PEAR_Error object on failure.
 */
function _imp_addUser($userId, $credentials)
{
    $params = $_SESSION['imp']['admin']['params'];
    $params['admin_user'] = $params['login'];
    $params['admin_password'] = Secret::read(Secret::getKey('imp'), $params['password']);
    require_once 'Horde/IMAP/Admin.php';
    $imap = &new IMAP_Admin($params);
    return $imap->addMailbox(String::convertCharset($userId, NLS::getCharset(), 'utf7-imap'));
}

/**
 * Delete a set of authentication credentials.
 *
 * @param string $userId  The userId to delete.
 *
 * @return mixed  True on success or a PEAR_Error object on failure.
 */
function _imp_removeUser($userId)
{
    $params = $_SESSION['imp']['admin']['params'];
    $params['admin_user'] = $params['login'];
    $params['admin_password'] = Secret::read(Secret::getKey('imp'), $params['password']);
    require_once 'Horde/IMAP/Admin.php';
    $imap = &new IMAP_Admin($params);
    return $imap->removeMailbox(String::convertCharset($userId, NLS::getCharset(), 'utf7-imap'));
}

/**
 * List all users in the system.
 *
 * @return mixed  The array of userIds, or a PEAR_Error object on failure.
 */
function _imp_userList()
{
    $params = $_SESSION['imp']['admin']['params'];
    $params['admin_user'] = $params['login'];
    $params['admin_password'] = Secret::read(Secret::getKey('imp'), $params['password']);
    require_once 'Horde/IMAP/Admin.php';
    $imap = &new IMAP_Admin($params);
    return $imap->listMailboxes();
}
