<?php
/**
 * Implementation of the Quota API for Courier IMAP servers.
 *
 * $Horde: imp/lib/Quota/courier.php,v 1.21 2004/05/20 15:45:34 jan Exp $
 *
 * Copyright 2002-2004 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @version $Revision: 1.21 $
 * @since   IMP 4.0
 * @package IMP_Quota
 */
class IMP_Quota_courier extends IMP_Quota {

    /**
     * Get quota information (used/allocated), in bytes.
     *
     * @access public
     *
     * @return mixed  An associative array.
     *                'limit' = Maximum quota allowed
     *                'usage' = Currently used portion of quota (in bytes)
     *                Returns PEAR_Error on failure.
     */
    function getQuota()
    {
        $quota = null;

        if (function_exists('imap_get_quotaroot')) {
            @$quota = imap_get_quotaroot($_SESSION['imp']['stream'], 'INBOX');
        } else {
            require_once IMP_BASE . '/lib/IMAP.php';
            $imp_imap = &IMP_IMAP::singleton();
            $stream = $imp_imap->openIMAPStream(null, OP_HALFOPEN);

            if ($stream !== false) {
                $quota = @imap_get_quota($stream, 'ROOT');
                @imap_close($stream);
            }
        }
        if (is_array($quota) && !empty($quota)) {
            if (!empty($quota['limit'])) {
                return array('usage' => $quota['usage'] * 1024, 'limit' => $quota['limit'] * 1024);
            } elseif (!empty($quota['STORAGE']['limit'])) {
                return array('usage' => $quota['STORAGE']['usage'] * 1024, 'limit' => $quota['STORAGE']['limit'] * 1024);
            }
            return array('usage' => 0, 'limit' => 0);
        }

        return PEAR::raiseError(_("Unable to retrieve quota"), 'horde.error');
    }

}
