<?php
/*
 * $Horde: imp/lib/Maintenance/Task/purge_trash.php,v 1.23 2004/05/20 15:45:33 jan Exp $
 *
 * Copyright 2001-2004 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Maintenance module that purges old messages in the Trash folder.
 *
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.23 $
 * @since   IMP 2.3.7
 * @package Horde_Maintenance
 */
class Maintenance_Task_purge_trash extends Maintenance_Task {

    /**
     * Purge old messages in the Trash folder.
     *
     * @access public
     *
     * @return boolean  Whether any messages were purged from the Trash folder.
     */
    function doMaintenance()
    {
        global $imp, $prefs, $notification;

        /* Check to make sure Trash folder is being used by IMP. */
        if ($prefs->getValue('use_trash')) {

            $trash_folder = IMP::addPreambleString($prefs->getValue('trash_folder'));
            /* Make sure the Trash folder exists. */
            require_once IMP_BASE . '/lib/Folder.php';
            $imp_folder = &IMP_Folder::singleton();
            if ($imp_folder->exists($imp['stream'], $trash_folder)) {

                /* Get the current UNIX timestamp minus the number of days
                     specified in 'purge_trash_keep'.
                   If a message has a timestamp prior to this value, it
                     will be deleted. */
                $del_time = date("r", time() - ($prefs->getValue('purge_trash_keep') * 86400));

                /* Open the Trash mailbox and get the list of messages older
                   than 'purge_trash_keep' days. */
                require_once IMP_BASE . '/lib/IMAP.php';
                require_once IMP_BASE . '/lib/Message.php';
                $imp_imap = &IMP_IMAP::singleton();
                $imp_message = &new IMP_Message();
                $imp_imap->changeMbox($trash_folder);
                $msg_ids = @imap_search($imp['stream'], "BEFORE \"$del_time\"", SE_UID);

                /* Go through the message list and delete the messages. */
                if (!empty($msg_ids)) {
                    $indices = array($trash_folder => $msg_ids);
                    $result = $imp_message->delete($indices, true);
                    if (is_a($result, 'PEAR_Error')) {
                        $notification->push($result, 'horde.message');
                    } else {
                        $notification->push(sprintf(_("Purging %d message(s) from Trash folder."), count($msg_ids)), 'horde.message');
                    }
                }

            }

        }

       return false;
    }

    /**
     * Return information for the maintenance function.
     *
     * @access public
     *
     * @return string  Description of what the operation is going to do during
     *                 this login.
     */
    function describeMaintenance()
    {
        global $prefs;

        return sprintf(_("All messages in your \"%s\" folder older than %s days will be permanently deleted."), $prefs->getValue('trash_folder'), $prefs->getValue('purge_trash_keep'));
    }

}
