#!/usr/bin/perl
#
#    $Horde: imp/scripts/imp2turba.pl,v 1.2.2.7 2004/05/24 09:01:34 jan Exp $
#
#    File:      imp2turba.pl
#    Author:    Micah Anderson - micah@riseup.net
#    Version:   1.4
#
#    Date:      8/7/01
#    Purpose:   This script converts an old imp addressbook database contents
#               to the newer turba addressbook format.
#
#    Usage:     Modify the variables at the beginning of the script
#               so that your database type/user/password, location and imp
#               database and turba database are correct. Then simply run
#               ./imp2turba.pl, if you have made the script executable, or
#               perl ./imp2turba.pl
#
#    Date:      5/12/01
#               tuning for imp2.2.7 to turba 1.0 by Christophe Guilloux <rootix@bootix.net>
#
#    Date:      27/5/02
#               make the database type configurable.
#
#    Date:      19/6/02
#               a few of the most important variables can now be also passed as arguments to
#               enable usage in scripts Tomas Pospisek - tpo_deb@sourcepole.ch
#
#    Date:      24/07/03
#               error resulting in:
#               DBD::mysql::st execute failed: Column count doesn't match value
#               count at row 1 at ./imp2turba.pl line 116
#               fixed -- diego@dis.epm.br

use DBI;
use Getopt::Long;

my $dbtype         = 'mysql';
# my $dbtype         = 'Pg';

my $location       = 'localhost';
my $port_num       = '3306';
my $username       = 'horde';
my $password       = '*****';

my $IMP_DATABASE   = 'horde';
my $IMP_TABLE      = 'imp_addr';
my $TURBA_DATABASE = 'horde';
my $TURBA_TABLE    = 'turba_objects';
my $domain         = 'example.com';

my $help = '';

GetOptions('help'             => \$help,
           'dbtype=s'         => \$dbtype,
           'username=s'       => \$username,
           'password=s'       => \$password,
           'port_num=i'       => \$port_num,
           'host=s'           => \$location,
           'domain=s'         => \$domain,
           'imp-database=s'   => \$IMP_DATABASE,
           'imp-table=s'      => \$IMP_TABLE,
           'turba-database=s' => \$TURBA_DATABASE,
           'turba-table=s'    => \$TURBA_TABLE);

if($help) {
   print <<EOF;
imp2turba.pl: converts an old imp addressbook to the
              newer turba database

optional parameters     Current settings:

    --dbtype            $dbtype
    --username          $username
    --password          $password
    --port_num          $port_num
    --host              $location
    --domain            $domain
    --imp-database      $IMP_DATABASE
    --imp-table         $IMP_TABLE
    --turba-database    $TURBA_DATABASE
    --turba-table       $TURBA_TABLE
EOF
    exit;
}

my $dbi_options = {RaiseError => 1, ChopBlanks => 1, AutoCommit => 1};

$db_imphandle = DBI->connect("DBI:$dbtype:$IMP_DATABASE:$location:$port_num",
                             $username, $password, $dbi_options)
                || die ("Connection error: $DBI::errstr");

$db_turbahandle = DBI->connect("DBI:$dbtype:$TURBA_DATABASE:$location:$port_num",
                               $username, $password, $dbi_options)
                  || die ("Connection error: $DBI::errstr");

$imp_statement = $db_imphandle->prepare("SELECT * FROM $IMP_TABLE");
$imp_statement->execute();

while (my ($owner, $address, $nickname, $fullname) = $imp_statement->fetchrow_array()) {

    @chars      = ("A" .. "Z", "a" .. "z", 0 .. 9, qw(! @ $ % ^ & *));
    $unique_key = join("", @chars[ map {rand @chars} (1 .. 31) ]);

    # Remove the @domain.com part from the $owner, doesn't work in Turba
    $owner =~ s/\@.*$//;
    $owner .= "\@$domain";

    # Quote the strings appropriately for the database
    my $quoted_key      = $db_imphandle->quote($unique_key);
    my $quoted_owner    = $db_imphandle->quote($owner);
    my $quoted_fullname = $db_imphandle->quote($fullname);
    my $quoted_address  = $db_imphandle->quote($address);
    my $quoted_nickname = $db_imphandle->quote($nickname);

    $turba_statement = "INSERT INTO $TURBA_TABLE (object_id,owner_id,object_name,object_alias,object_email) VALUES
                        ($quoted_key, $quoted_owner, $quoted_fullname,
                        $quoted_nickname,$quoted_address)";

    $turba_statement = $db_turbahandle->prepare($turba_statement)
                       || die "prepare: $$stmt: $DBI::errstr";
    $turba_statement->execute || die "execute: $$stmt: $DBI::errstr";
    $turba_statement->finish();

}

$imp_statement->finish();
$turba_statement->finish();
$db_imphandle->disconnect;
$db_turbahandle->disconnect;
