<?php

/*
 
 File: login.php3
 $Author: bjn $
 $Revision: 2.10.2.17 $
 $Date: 2002/03/28 16:53:15 $
 
 IMP: Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
*/

require '../lib/horde.lib';
require './lib/imp.lib';
require '../config/horde.php3';
require './config/defaults.php3';
require './config/html.php3';
require './config/lang.php3';

$language = select_lang('', true);
require './lib/postconf.php3';

require "./locale/$language/login.lang";
require './locale/local/login.lang';
$help_file = 'login.help';
require "./locale/defines/$help_file";
require './config/lang.php3';

$this_client = new WebClient;
error_reporting($default->error_level);
if (!isset($reason)) { 
    $reason = 'login'; 
} else {
    $reason = htmlspecialchars($reason);
}

/* if there is an existing session, redirect to the mailbox */
page_open(array('sess' => 'HordeSession'));
if (isset($imp) && is_object($imp)) {
  if ($reason == 'logout' || $reason == 'timeout' || $reason == 'chpass') {
    $sess->unregister('imp');
    // non-cookie sessions will just have to timeout, since PHPLIB is silly
    // and doesn't handle itself right for deleting them.
    // if ($sess->mode == 'cookie') $sess->delete();
    $sess->delete();
  }
  else { page_close(); header('Location: ' . $sess->url('mailbox.php3')); exit; }
}
page_close();

$langs = '<select name="new_lang" onchange="selectLang()">';
while (list($key, $val) = each($lang->lang)) {
   if ($key == $language) $sel = ' SELECTED';
   else $sel = '';
   $langs .= "<option value=\"$key\"$sel>$val</option>\n";
}
$langs .= '</select>';

if ($default->log_stats) {
	openlog($default->log_ident, LOG_PID, $default->log_stats_facil);
	syslog($default->log_prio, "login.php3 $REMOTE_ADDR $reason");
	closelog();
}

require "$default->include_dir/doctype.inc";

status('');
if (!$this_client->lynx) {
    include("$default->include_dir/login/login.inc");
} else {
    include("$default->include_dir/login/login_lynx.inc");
    include_lynx_menu(IMPMENU_BLANK); /* Menu Mode = IMPMENU_BLANK */
}

include './config/MOTD.html';
include "$default->include_dir/generic-footer.inc";

?>
