<?php

/*
 
 File: compose.php3
 $Author: bjn $
 $Revision: 2.35.2.85 $
 $Date: 2002/03/28 16:53:15 $
 
 IMP: Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */


/* check for non-standard address formats, such as seperating with
   spaces or semicolons. */
function format_addresses ($address_string) {
	// if there are angle brackets (<>) assume the user knew what they were doing
	if (!is_string(strstr($address_string, '>'))) { // check return value explicitly because it might be 0
		$address_string = trim(strtr($address_string, ';,', '  '));
		$address_string = preg_replace('|\s+|', ', ', $address_string);
	}
	return $address_string;
}

/* format a from: address correctly based on all relevant factors... */
function get_from () {
	global $default, $from, $imp;
  
	if ($default->user_change_fullname || $default->use_db)
		$name = imp_get_fullname($imp->user, $imp->server);
  
	if (empty($name)) $name = '';

	if (!isset($from) || !$from || !$default->user_change_from) {
		$from = '';
		if ($name) {
			$from  = $name;
			$from .= ' <';
		}
		$from .= get_barefrom();
		if ($name) {
			$from .= '>';
		}
	}
  
	return $from;
}

/*
 * Return the value of upload_tmp_dir, or default to '/tmp'
 */
function tmpdir()
{
    $tmp = get_cfg_var('upload_tmp_dir');
    if (empty($tmp)) {
	$tmp = getenv('TMPDIR');
    }
    return (empty($tmp) ? '/tmp' : $tmp);
}

/*
 * Make sure a path is inside of the upload directory.
 */
function safe_file($file) {
    return tmpdir() . '/' . basename($file);
}

/* Obtain the date offset. Thanks to Javier Kohen <jkohen@tough.com>
 * for fixing this for wrap-around
 */
function gm_offset () {
    $date = date('H');
    $gmdate = gmdate('H');
    /* Adjust for wrap-around, the difference can't be more than 12 hours.
     * AFAIK, -1200 is invalid, the correct one is +1200 (ie: at New Zealand).
     *
     * CHANGED Oct 18 2000 (Submitted by <demian@coretech.co.nz>) to handle
     * New Zealand daylight savings time.
     */
    if ($gmdate + 13 < $date) {
		$gmdate += 24;
    } else if ($date + 11 <= $gmdate) {
		$date += 24;
    }
    $offset = $date - $gmdate;
    if ($offset >= 0) {
		return sprintf("+%02d", $offset) . "00";
    } else {
		return sprintf("-%02d", -$offset) . "00";
    }
}

// if $id=2.1, returns $structure->parts[1]->parts[0]
function partFromId ($structure, $id) {
	$res = $structure;
	if (isset($res->parts[0])) {
		$piece = explode('.', $id);
		$num = count($piece);
		$ind = 0;
		$j = 0;
		while ($j < $num) {
			$ind = $piece[$j]-1;
			$res = $res->parts[$ind];
			$j++;
		}
	}
	return $res;
}

function find_text_part (&$attachments) {
	reset($attachments);
	while (list(,$mime) = each($attachments)) {
		mimeParse($mime);
		if ($mime->type == TYPETEXT) {
			return MimeFetchDecodedContent($mime);
		}
	}
	return '';
}

/* add the attachments to the message in the case of a forward with attachments */
function attach_files ($part, $ref) {
	global $msg, $bodypart, $mailbox, $index, $attachments_name, $attachments_size, $attachments_file, $attachments_type, $total_size;
  
	$num_parts = count($part->parts);
	for ($j=1; $j<$num_parts; $j++) {
		if (strlen($ref) == 0)
			$aref = '' . ($j+1);
		else
			$aref = $ref . '.' . ($j+1);
		if (isset($part->parts[$j])) {
			$p = $part->parts[$j];
			if (isset($p->parts[0]))
				$msg = attach_files($p, $aref, $msg);
		}
		else {
			$p = $part;
		}
		$mime = new mime_part_data;
		$mime->set_imap_data($index, $aref);
		$mime->parse($p);
    
		$file_upload_name = $mime->name;
		$file_upload_size = $mime->size;
		$file_upload_type = $mime->type_text . '/' . $mime->subtype;
		$file_upload = $aref;
    
		if (isset($attachments_name) && !is_array($attachments_name)) { $attachments_name = array($attachments_name); }
		if (isset($attachments_size) && !is_array($attachments_size)) { $attachments_size = array($attachments_size); }
		if (isset($attachments_file) && !is_array($attachments_file)) { $attachments_file = array($attachments_file); }
		if (isset($attachments_type) && !is_array($attachments_type)) { $attachments = array($attachments_type); }
    
		$attachments_name[] = $file_upload_name;
		$attachments_size[] = $file_upload_size;
		$attachments_file[] = $index . "-" . $file_upload . ".mime";
		$attachments_type[] = $file_upload_type;
		$total_size = 0;
    
		for ($i=0; $i<count($attachments_size); $i++) {
			$total_size += $attachments_size[$i];
		}
	}
}


$need_horde_db = 1;
require '../lib/horde.lib';
require './lib/imp.lib';                   /* IMPlib is the IMP function library  */
require '../config/horde.php3';
require './config/defaults.php3';          /* Defaults configuration file         */
require './config/lang.php3';
require './lib/version.php';

/* Html styles configuration */
require '../config/html.php3';
require './config/html.php3';
/* include mime and language configuration */
require './config/mime.php3';

require '../lib/mime.lib';                  /* Mime lib for composing mime messages */
require './lib/mimetypes.lib';

$language = select_lang();
require './lib/postconf.php3';
require "./locale/$language/compose.lang";
require "./locale/local/compose.lang";
$help_file = 'compose.help';
require "./locale/defines/$help_file";
require './config/lang.php3';

/* Setup the this_client object */
$this_client = new WebClient;
error_reporting($default->error_level);

/* Adjust the form element sizes for the appropriate screen size */
if ($_html['screen_size'] == 'small') {
	$_html['smresize'] = 0.7;
	$_html['bgresize'] = 0.5;
	$_html['compose_headers_size'] = $_html['compose_headers_size'] * $_html['smresize'];
	$_html['compose_attach_size'] = $_html['compose_attach_size'] * $_html['smresize'];
	$_html['compose_body_cols'] = $_html['compose_body_cols'] * $_html['smresize'];
	$_html['compose_body_rows'] = $_html['compose_body_rows'] * $_html['bgresize'];
} else if ($_html['screen_size'] == 'large') {
	$_html['smresize'] = 1;
	$_html['bgresize'] = 1;
}

if ($this_client->ns) {
	page_open(array('sess' => 'HordeSessionCached'));
} else {
	page_open(array('sess' => 'HordeSession'));
}
page_close();
if (!isset($imp) || !is_object($imp)) { echo '<script language="JavaScript">window.close()</script>'; exit; }
$imp->unpickle();
$imp->authenticate(); /* login */
$get_sig = true;

/* array to translate string actions into the appropriate integer ID */
$actions[$lang->button_send] = SEND_MESSAGE;
$actions[htmlentities($lang->button_send)] = SEND_MESSAGE;

$actions[$lang->button_attach] = ADD_ATTACHMENT;
$actions[htmlentities($lang->button_attach)] = ADD_ATTACHMENT;

$actions[$lang->button_bounce] = BOUNCE_MESSAGE;
$actions[htmlentities($lang->button_bounce)] = BOUNCE_MESSAGE;

$actions[$lang->button_cancel] = CANCEL;
$actions[htmlentities($lang->button_cancel)] = CANCEL;

$actions[$lang->button_delete_attach] = DELETE_ATTACHMENT;
$actions[htmlentities($lang->button_delete_attach)] = DELETE_ATTACHMENT;
$actions[$lang->button_postpone] = POSTPONE_DRAFT;
$actions[htmlentities($lang->button_postpone)] = POSTPONE_DRAFT;

if (isset($index)) {
    $index = intval($index);  // prevent abuse
}

/* doctype */
require "$default->include_dir/doctype.inc";

/* Run through action handlers */
if (isset($actionID)) {
	/* translate non-int values into the correct int */
	if (strcspn($actionID, '0123456789')) {
	    $actionID = isset($actions[$actionID]) ? $actions[$actionID] : $actions[htmlentities($actionID)];
	}
	
	switch ($actionID) {
	case NO_ACTION:
		/* don't want it to hit the IMAP server here - nuke the refresh */
		unset($default->refresh_delay);
		status($lang->status_composition);
		$ACTION_TEXT = $lang->status_composition;
		break;
    
	case COMPOSE:
		if (isset($to)) {
			$to = chop(decode_mime_string($to));
		}
		if (isset($subject)) {
			$subject = chop(decode_mime_string($subject));
		}
		$ACTION_TEXT = $lang->action_compose;
		break;
    
	case MAILTO:
		if ($imp->mailbox && $index) {
			$h = @imap_header($imp->stream, imap_msgno($imp->stream, $index));
			if (isset($mailto) && isset($h->$mailto)) {
				$to = chop(decode_mime_string($h->$mailto));
			} else if (!empty($h->reply_toaddress)) {
				$to = chop(decode_mime_string($h->reply_toaddress));
			} else if (!empty($h->fromaddress)) {
				$to = chop(decode_mime_string($h->fromaddress));
			} else {
				$to = '';
			}
			$ACTION_TEXT = $lang->action_compose;
		}
		break;
    
	case DRAFT:
		if ($mailbox && $index && $bodypart) {
			$h = imap_header($imp->stream, imap_msgno($imp->stream, $index));
      
			if ($h) {
				if (isset($h->fromaddress)) $from = chop(decode_mime_string($h->fromaddress));
				if (isset($h->toaddress)) $to = chop(decode_mime_string($h->toaddress));
				if (isset($h->ccaddress)) $cc = chop(decode_mime_string($h->ccaddress));
				if (isset($h->bccaddress)) $bcc = chop(decode_mime_string($h->bccaddress));
				if (isset($h->reply_toaddress)) $reply_to = chop(decode_mime_string($h->reply_toaddress));
				if (isset($h->subject)) $subject = chop(decode_mime_string($h->subject));
			}
      
			$quote_str = "\n" . $default->quote_prefix;
			$msg = imap_fetchbody($imp->stream, $index, $bodypart, FT_UID);
			$ACTION_TEXT = $lang->action_compose;
			$structure = @imap_fetchstructure($imp->stream, $index, FT_UID);
			if (@count($structure->parts) > 1) {
				attach_files($structure, '');
			}
			$get_sig = false;
		}
		break;
    
	case REPLY:
		if ($imp->mailbox && $index && $bodypart) {
			$h = imap_header($imp->stream, imap_msgno($imp->stream, $index));
      
			/* Set the message_id and references headers */
			if (isset($h->message_id)) {
				$in_reply_to = chop($h->message_id);
				if (isset($h->references)) {
					$references = chop($h->references) . ' ' . $in_reply_to;
				} else {
					$references = $in_reply_to;
				}
			} else {
				$in_reply_to = '';
				$references = '';
			}
      
			if (isset($h->reply_toaddress))
				$to = chop(decode_mime_string($h->reply_toaddress));
			else if (isset($h->fromaddress))
				$to = chop(decode_mime_string($h->fromaddress));
			else
				$to = '';
      
			if (isset($h->fromaddress))
				$qfrom = chop(decode_mime_string($h->fromaddress));
			else $qfrom = '&lt;&gt;';
      
			$quote_str = "\n" . $default->quote_prefix;
			$structure = imap_fetchstructure($imp->stream, $index, FT_UID);
			$foo = false;
			$attachments = MimeParseStructure($structure, '', $foo);
			$msg = find_text_part($attachments);
			$msg = wrap_message($msg, $_html['compose_body_cols'] - 8, $quote_str);
			$msg  = $lang->quoting_string . ' ' . $qfrom . ":\n$quote_str$msg";
			$msg .= "\n";
	
			if (isset($h->subject) && (strtolower(substr(trim(decode_mime_string($h->subject)), 0, 3)) != 're:'))
				$subject = 'Re: ' . chop(decode_mime_string($h->subject));
			else if (isset($h->subject))
				$subject = chop(decode_mime_string($h->subject));
			else
				$subject = 'Re: ';
      
			$ACTION_TEXT = $lang->action_reply . ' ' . $subject;
		}
		break;
    
	case REPLY_ALL:
		if ($imp->mailbox && $index && $bodypart) {
			$h = imap_header($imp->stream, imap_msgno($imp->stream, $index));
      
			/* Set the message_id and references headers */
			if (isset($h->message_id)) {
				$in_reply_to = chop($h->message_id);
				if (isset($h->references)) {
					$references = chop($h->references) . ' ' . $in_reply_to;
				} else {
					$references = $in_reply_to;
				}
			} else {
				$in_reply_to = '';
				$references = '';
			}
      
			if (!empty($h->reply_toaddress)) {
				$reply = chop(decode_mime_string($h->reply_toaddress));
			} else if (!empty($h->fromaddress)) {
				$reply = chop(decode_mime_string($h->fromaddress));
			} else {
				$reply = '';
			}
			
			/* make a few checks unnecessary by initializing these */
			if (empty($h->fromaddress)) $h->fromaddress = '';
			if (empty($h->toaddress)) $h->toaddress = '';
			
			/* build up the reply to all addresses */
			if ($reply != chop(decode_mime_string($h->fromaddress))) {
				$to = $reply . ',' . chop(decode_mime_string($h->fromaddress));
			} else {
				$to = $reply;
			}
			if ($reply != chop(decode_mime_string($h->toaddress))) {
				$cc = chop(decode_mime_string($h->toaddress));
				if (!empty($h->ccaddress)) {
					$cc .= ',' . chop(decode_mime_string($h->ccaddress));
				}
			} else if (!empty($h->ccaddress)) {
				$cc = chop(decode_mime_string($h->ccaddress));
			}
			
			if (!empty($h->bccaddress)) {
				$bcc = ',' . chop(decode_mime_string($h->bccaddress));
			}
      
			$quote_str = "\n" . $default->quote_prefix;
			$structure = imap_fetchstructure($imp->stream, $index, FT_UID);
			$foo = false;
			$attachments = MimeParseStructure($structure, '', $foo);
			$msg = find_text_part($attachments);
			$msg = wrap_message($msg, $_html['compose_body_cols'] - 8, $quote_str);
			$msg  = $lang->quoting_string . ' ' . chop(decode_mime_string($h->fromaddress)) . ":\n$quote_str$msg";
			$msg .= "\n";
      
			if (isset($h->subject) && strtolower(substr(trim(decode_mime_string($h->subject)), 0, 3)) != 're:') $subject = 'Re: ' . chop(decode_mime_string($h->subject));
			else if (isset($h->subject)) $subject = chop(decode_mime_string($h->subject));
			else $subject = '';
      
			$ACTION_TEXT = $lang->action_reply_all . ' ' . $subject;
		}
		break;
    
	case FORWARD:
		if ($imp->mailbox && $index && $bodypart) {
			$h = imap_header($imp->stream, imap_msgno($imp->stream, $index));
			if (isset($h->fromaddress))
				$message_source = chop(decode_mime_string($h->fromaddress));
			else
				$message_source = '';
			$from = get_from();
      
			$msg  = "\n" . $lang->forwarded_from($message_source) . "\n";
      
			if (isset($h->date) && $h->date) { $msg .= 'Date: ' . chop(decode_mime_string($h->date)) . "\n"; }
			if (isset($h->fromaddress) && $h->fromaddress) { $msg .= 'From: ' . chop(decode_mime_string($h->fromaddress)) . "\n"; }
			if (isset($h->reply_toaddress) && $h->reply_toaddress) { $msg .= 'Reply-To: ' . chop(decode_mime_string($h->reply_toaddress)) . "\n"; }
			if (isset($h->subject) && $h->subject) { $msg .= 'Subject: ' . chop(decode_mime_string($h->subject)) . "\n"; }
			if (isset($h->toaddress) && $h->toaddress) { $msg .= 'To: ' . chop(decode_mime_string($h->toaddress)) . "\n"; }
			$msg .= "\n";
			$msg .= wrap_message(imap_fetchbody($imp->stream, $index, $bodypart, FT_UID));
			$msg .= "\n----- " . $lang->forward_end_string . " -----\n";
			if ($qprint_msg = imap_qprint($msg)) {
				$msg = $qprint_msg;
			}
      
			if (isset($h->subject)) {
				$subject = $lang->fwd_string . ' ' . chop(decode_mime_string($h->subject));
				$ACTION_TEXT = $lang->action_forward . ' ' . chop(decode_mime_string($h->subject));
			} else {
				$subject = $lang->fwd_string;
				$ACTION_TEXT = $lang->action_forward;
			}
			$structure = @imap_fetchstructure($imp->stream, $index, FT_UID);
			if (@count($structure->parts) > 1) {
				attach_files($structure, '');
			}
		}
		break;
    
	case BOUNCE_MESSAGE:
		if ($imp->mailbox && $index && $to) {
			$recipients = $to;
      
			$headers = imap_fetchheader($imp->stream, $index, FT_UID);
			$headers = str_replace("\r", '', $headers);
			$header_arr = explode("\n", $headers);
			for ($i=0; $i<count($header_arr); $i++) {
				if (!empty($header_arr[$i]) && $header_arr[$i] != '' && $header_arr[$i] != "\n") {
					if (preg_match("|^([-\\w]*): (.*)|", $header_arr[$i], $pieces)) {
						$envelope[$pieces[1]] = $pieces[2];
						$last = $pieces[1];
					} else {
						if (isset($last) && $envelope[$last]) {
							$envelope[$last] .= "\n" . $header_arr[$i];
						}
					}
				}
			}
      
			$envelope['Resent-Date'] = date('D, d M Y H:i:s ') . gm_offset() . ' (' . strftime('%Z') . ')';
			$envelope['Resent-From'] = get_barefrom();
			$envelope['Resent-To'] = $to;
			$envelope['Resent-Message-ID'] = '<' . uniqid(time() . '.') . '@' . $SERVER_NAME . '>';
			$msg = imap_body($imp->stream, $index, FT_UID);
      
			if (mailfrom($recipients, $envelope, $msg)) {
				status($lang->status_bounce_success);
				$status_result = $lang->status_bounce_success;
				if ($default->minimum_popups || $this_client->rather_not_popup) {
					include "$default->include_dir/generic-header.inc";
					include "$default->include_dir/compose/results.inc";
					include "$default->include_dir/generic-footer.inc";
					exit;
				}
	
				if (!$this_client->lynx) {
					echo '<script language="JavaScript">self.close();</script></body></html>';
				} else {
					include('./mailbox.php3');
				}
				exit;
			}
			unset($to);
			unset($msg);
		}
		break;
    
	case SEND_MESSAGE:
		if (isset($is_reply) && isset($index) && isset($imp->mailbox) && $is_reply) {
			imap_setflag_full($imp->stream, $index, '\\ANSWERED', SE_UID);
		}
		
		if (isset($attachments_name) && !is_array($attachments_name)) { $attachments = array($attachments_name); }
		if (isset($attachments_size) && !is_array($attachments_size)) { $attachments = array($attachments_size); }
		if (isset($attachments_file) && !is_array($attachments_file)) { $attachments = array($attachments_file); }
		if (isset($attachments_type) && !is_array($attachments_type)) { $attachments = array($attachments_type); }
		
		if ($to && isset($message)) {
			$message = str_replace("\r\n", "\n", $message);
			$mime = new MimeMessage($message);
			
			$text_part = new mime_part;
			$text_part->type = 'text';
			$text_part->subtype = 'plain';
			$text_part->contents = $message;
			if ($default->append_trailer) {
				/* add footer to text_part */
				$config_trailer = "\n" . implode(@file('./config/trailer.txt'), '');
				$config_trailer = set_env_in_string($config_trailer);
				$text_part->contents .= $config_trailer;
			}
			$mime->add_begin_part($text_part);
			
			if (isset($attachments_name) && is_array($attachments_name) && count($attachments_name) > 0) {
				for ($i = 0; $i < count($attachments_name)-1; $i++) {
					/* read it from the filesystem if its a normal attachment */
					if (!preg_match("|.mime$|", $attachments_file[$i])) {
						$fd = fopen (safe_file($attachments_file[$i]), 'r');
						$contents = fread($fd, $attachments_size[$i]);
						fclose($fd);
						unlink(safe_file($attachments_file[$i]));
					} else {
						/* fetch it from the mail message if its a forwarded attachment */
						preg_match("|(.*)-(.*).mime|", $attachments_file[$i], $regs);
						$message_index = $regs[1];
						$message_part = $regs[2];
						$forwarded_mime = new mime_part_data;
						$mime_structure = imap_fetchstructure($imp->stream, $message_index, FT_UID);
						$part_structure = partFromId($mime_structure, $message_part);
						$forwarded_mime->parse($part_structure);
						$contents = imap_fetchbody($imp->stream, $message_index, $message_part, FT_UID);
						if ($forwarded_mime->encoding == 3)
							$contents = imap_base64($contents);
						else if ($forwarded_mime->encoding == 4 && ($qprint_msg = imap_qprint($contents)))
							$contents = $qprint_msg;
					}
					
					$file_part = new mime_part;
					
					/* some browsers do not send mime type */
					if (strcmp($attachments_type[$i], '')) { 
						$file_part->parse_full_type($attachments_type[$i]);
					} else { 
						$file_part->parse_full_type('application/octet-stream');
					}
					
					$file_part->name = $attachments_name[$i];
					
					/* if the type is text, we shouldn't base64 it */
					if ($file_part->type == 'text') {
						$file_part->contents = $contents;
					} else {
						$file_part->transfer_encoding = 'base64';
						$file_part->contents = chunk_split(base64_encode($contents), 73, "\n") . "\n";
					}
					$mime->add_middle_part($file_part);
				}
				
				$i = count($attachments_name)-1;
				
				/* read it from the filesystem if its a normal attachment */
				if (!preg_match("|.mime$|", $attachments_file[$i])) {
					$fd = fopen (safe_file($attachments_file[$i]), 'r');
					$contents = fread($fd, $attachments_size[$i]);
					fclose($fd); 
					unlink(safe_file($attachments_file[$i]));
				} else {
					/* fetch it from the mail message if its a forwarded attachment */
					preg_match("|(.*)-(.*).mime|", $attachments_file[$i], $regs);
					$message_index = $regs[1];
					$message_part = $regs[2];
					$forwarded_mime = new mime_part_data;
					$mime_structure = imap_fetchstructure($imp->stream, $message_index, FT_UID);
					$part_structure = partFromId($mime_structure, $message_part);
					$forwarded_mime->parse($part_structure);
					$contents = imap_fetchbody($imp->stream, $message_index, $message_part, FT_UID);
					if ($forwarded_mime->encoding == 3)
						$contents = imap_base64($contents);
					else if ($forwarded_mime->encoding == 4 && ($qprint_msg = imap_qprint($contents)))
						$contents = $qprint_msg;
				}
				
				$file_part = new mime_part;
				
				/* some browsers do not send mime type */
				if (strcmp($attachments_type[$i], '')) { 
					$file_part->parse_full_type($attachments_type[$i]);
				} else { 
					$file_part->parse_full_type('application/octet-stream');
				}
				
				$file_part->name = $attachments_name[$i];
	
				/* if the type is text, we shouldn't base64 it */
				if ($file_part->type == 'text') {
					$file_part->contents = $contents;
				} else {
					$file_part->transfer_encoding = "base64";
					$file_part->contents = chunk_split(base64_encode($contents)) . "\n";
				}
				$mime->add_end_part($file_part);
			}
			$msg = $mime->generate();
			
			$recipients = '';
			$from = get_from();
			$envelope['Message-ID'] = '<' . uniqid(time() . '.') . '@' . $SERVER_NAME . '>';
			$envelope['Date'] = date("D, d M Y H:i:s ") . gm_offset() . ' (' . strftime('%Z') . ')';
			
			$to = format_addresses($to);
			$envelope['To'] = $to;
			$envelope['From'] = $from;
			$recipients = $to;
			if (!empty($cc)) {
				$cc = format_addresses($cc);
				$envelope['Cc'] = $cc;
				$recipients .= ', ' . $cc;
			}
			if (!empty($bcc)) {
				$bcc = format_addresses($bcc);
				$envelope['Bcc'] = $bcc;
				$recipients .= ', ' . $bcc;
			}
      
			if (isset($subject) && $subject)
				$envelope['Subject'] = $subject;
			if (isset($references))
				$envelope['References'] = $references;
			if (isset($in_reply_to))
				$envelope['In-Reply-To'] = $in_reply_to;
			$envelope = $mime->header($envelope);
			$envelope['User-Agent'] = 'IMP/PHP IMAP webmail program ' . IMP_VERSION;
			
			if (mailfrom($recipients, $envelope, $msg)) {
				status($lang->status_send_success);
				$status_result = $lang->status_send_success;
				
				if ($default->user_use_folders && $default->save_sent_mail) {
					// Loop through the envelope and add headers.
					reset($envelope);
					$fcc = '';
					while (list($key, $val) = each($envelope)) {
						if ($key != 'recipients')
							$fcc .= $key . ': ' . $val . "\n";
					}
					$fcc .= "\n";
					$fcc .= $msg;
					
					$preamble = $imp->folders . $default->personal_folders;
                    $sent_folder = imap_utf7_encode($preamble . $default->sent_mail);
					
					if (!imap_listmailbox($imp->stream, '{' . $imp->server . ':' . $imp->port . '}', $sent_folder)) {
						@imap_createmailbox($imp->stream, '{' . $imp->server . ':' . $imp->port . '}' . $sent_folder);
						if ($default->use_imap_subscribe) {
							@imap_subscribe($imp->stream, '{' . $imp->server . ':' . $imp->port . '}' . $sent_folder);
						}
						imp_reload_frame('impfolder', $sess->url('select.php3?uniq=' . uniqid(rand())));
					}
					$fcc = str_replace("\n", "\r\n", $fcc);
					if (!(@imap_append($imp->stream, '{' . $imp->server . ':' . $imp->port . '}' . $sent_folder, $fcc, '\\Seen'))) {
						status($lang->status_send_save_error . ' ' . $preamble . $default->sent_mail);
						$status_result = $lang->status_send_save_error . ' ' . $default->sent_mail;
					}
				}
				
				if ($default->minimum_popups || $this_client->rather_not_popup) {
					include "$default->include_dir/generic-header.inc";
					include "$default->include_dir/compose/results.inc";
					include "$default->include_dir/generic-footer.inc";
					exit;
				}
				
				if (!$this_client->lynx) {
					echo '<script language="JavaScript">self.close();</script></body></html>';
				} else {
					include './mailbox.php3';
				}
				exit;
			}
		}
		$total_size = 0;
		if (isset($attachments_size) && is_array($attachments_size)) {
			for ($i = 0; $i < count($attachments_size); $i++) {
				$total_size += $attachments_size[$i];
			}
		}
		$get_sig = false;
		$ACTION_TEXT = $lang->status_send_error;
		break;
    
	case POSTPONE_DRAFT:
		$append_flags = '\\Draft';
    
	case POSTPONE_MESSAGE:
		$preamble = $imp->folders . $default->personal_folders;
		$copyto = imap_utf7_encode($preamble . $default->postponed);
		if (!empty($copyto)) {
			$total_size = 0;
			if (isset($attachments_size) && is_array($attachments_size)) {
				for ($i = 0; $i < count($attachments_size); $i++) {
					$total_size += $attachments_size[$i];
				}
			}
			if (isset($message)) {
				$msg = $message; // save for later.
				
				$message = str_replace("\r\n", "\n", $message);
				$mime = new MimeMessage($message);
				
				$text_part = new mime_part;
				$text_part->type = 'text';
				$text_part->subtype = 'plain';
				$text_part->contents = $message;
				$mime->add_begin_part($text_part);
				
				if (isset($attachments_name) && is_array($attachments_name) && count($attachments_name) > 0) {
					for ($i = 0; $i < count($attachments_name)-1; $i++) {
						/* read it from the filesystem if its a normal attachment */
						if (!preg_match("|\.mime$|", $attachments_file[$i])) {
							$fd = fopen (safe_file($attachments_file[$i]), 'r');
							$contents = fread($fd, $attachments_size[$i]);
							fclose($fd); 
							unlink(safe_file($attachments_file[$i]));
						} else {
							/* fetch it from the mail message if its a forwarded attachment */
							preg_match("|(.*)-(.*).mime|", $attachments_file[$i], $regs);
							$message_index = $regs[1];
							$message_part = $regs[2];
							$forwarded_mime = new mime_part_data;
							$mime_structure = imap_fetchstructure($imp->stream, $message_index, FT_UID);
							$part_structure = partFromId($mime_structure, $message_part);
							$forwarded_mime->parse($part_structure);
							$contents = imap_fetchbody($imp->stream, $message_index, $message_part, FT_UID);
							if ($forwarded_mime->encoding == 3)
								$contents = imap_base64($contents);
							else if ($forwarded_mime->encoding == 4 && ($qprint_msg = imap_qprint($contents)))
								$contents = $qprint_msg;
						}
	    
						$file_part = new mime_part;
	    
						/* some browsers do not send mime type */
						if (strcmp($attachments_type[$i], '')) { 
							$file_part->parse_full_type($attachments_type[$i]);
						} else { 
							$file_part->parse_full_type('application/octet-stream');
						}
	    
						$file_part->name = $attachments_name[$i];
	    
						/* if the type is text, we shouldn't base64 it */
						if ($file_part->type == 'text') {
							$file_part->contents = $contents;
						} else {
							$file_part->transfer_encoding = 'base64';
							$file_part->contents = chunk_split(base64_encode($contents), 73, "\n") . "\n";
						}
						$mime->add_middle_part($file_part);
					}
	  
					$i = count($attachments_name)-1;
	  
					/* read it from the filesystem if its a normal attachment */
					if (!preg_match("|.mime$|", $attachments_file[$i])) {
						$fd = fopen(safe_file($attachments_file[$i]), 'r');
						$contents = fread($fd, $attachments_size[$i]);
						fclose($fd); 
						unlink(safe_file($attachments_file[$i]));
					} else {
						/* fetch it from the mail message if its a forwarded attachment */
						preg_match("|(.*)-(.*).mime|", $attachments_file[$i], $regs);
						$message_index = $regs[1];
						$message_part = $regs[2];
						$forwarded_mime = new mime_part_data;
						$mime_structure = imap_fetchstructure($imp->stream, $message_index, FT_UID);
						$part_structure = partFromId($mime_structure, $message_part);
						$forwarded_mime->parse($part_structure);
						$contents = imap_fetchbody($imp->stream, $message_index, $message_part, FT_UID);
						if ($forwarded_mime->encoding == 3)
							$contents = imap_base64($contents);
						else if ($forwarded_mime->encoding == 4 && ($qprint_msg = imap_qprint($contents)))
							$contents = $qprint_msg;
					}
	  
					$file_part = new mime_part;
	  
					/* some browsers do not send mime type */
					if (strcmp($attachments_type[$i], '')) { 
						$file_part->parse_full_type($attachments_type[$i]);
					} else { 
						$file_part->parse_full_type('application/octet-stream');
					}
	  
					$file_part->name = $attachments_name[$i];
	  
					/* if the type is text, we shouldn't base64 it */
					if ($file_part->type == 'text') {
						$file_part->contents = $contents;
					} else {
						$file_part->transfer_encoding = "base64";
						$file_part->contents = chunk_split(base64_encode($contents)) . "\n";
					}
					$mime->add_end_part($file_part);
				}
				$body = $mime->generate();
			} else {
				$body = '';
			}
      
			$from = get_from();
      
			$hdrs = '';
			if ($from != '') {
				$hdrs .= "From: $from\n";
			}
			if ($to != '') {
				$hdrs .= "To: $to\n";
			}
			if ($cc != '') {
				$hdrs .= "Cc: $cc\n";
			}
			if ($bcc != '') {
				$hdrs .= "Bcc: $bcc\n";
			}
			if ($subject != '') {
				$hdrs .= "Subject: $subject\n";
			}
			
			// FIXME
			// The absence of Mime-Version here should really be taken care of
			// in horde/lib/mime.lib, but I'm not sure how, and this at least
			// makes it *work*. Blame <rich@alcor.concordia.ca>.
			$hdrs .= "Mime-Version: 1.0\n";
			
			if (isset($mime)) {
				$hdrs .= $mime->textHeader();
			}
			
			$body = $hdrs . "\n" . $body;
			$body = str_replace("\n", "\r\n", $body);
			
			if (isset($append_flags)) {
				$append_flags .= ' \\Seen';
			} else {
				$append_flags = '\\Seen';
			}
			if (!imap_listmailbox($imp->stream, '{' . $imp->server . ':' . $imp->port . '}', $copyto)) {
				@imap_createmailbox($imp->stream, '{' . $imp->server . ':' . $imp->port . '}' . $copyto);
				if ($default->use_imap_subscribe) {
					@imap_subscribe($imp->stream, '{' . $imp->server . ':' . $imp->port . '}' . $copyto);
					imp_reload_frame('impfolder', $sess->url('select.php3?uniq=' . uniqid(rand())));
				}
			}
			if (!(@imap_append($imp->stream, '{' . $imp->server . ':' . $imp->port . "}$copyto", $body, $append_flags))) {
				echo '<script language="JavaScript">alert("save message failed:\n' . addslashes(imap_last_error()) . '");</script>';
			} else {
				if ($default->minimum_popups || $this_client->rather_not_popup) {
					$status_result = $lang->status_message_postponed;
					include "$default->include_dir/generic-header.inc";
					include "$default->include_dir/compose/results.inc";
					include "$default->include_dir/generic-footer.inc";
					exit;
				}
	
				if (!$this_client->lynx) {
					echo '<script language="JavaScript">self.close();</script></body></html>';
				} else {
					include './mailbox.php3';
				}
				exit;
			}
		}
		$get_sig = false;
		$ACTION_TEXT = $lang->status_message_postponed;
		break;
    
	case ADD_ATTACHMENT:
		if (isset($attachments_name) && !is_array($attachments_name)) { $attachments_name = array($attachments_name); }
		if (isset($attachments_size) && !is_array($attachments_size)) { $attachments_size = array($attachments_size); }
		if (isset($attachments_file) && !is_array($attachments_file)) { $attachments_file = array($attachments_file); }
		if (isset($attachments_type) && !is_array($attachments_type)) { $attachments = array($attachments_type); }
	    
		/*
		 * NOTE that PHP tempnam() doesn't use mkstemp() until PHP 4.0.3!
		 * If using PHP 3.0.x, patch your PHP to use mkstemp(), to avoid
		 * the possibility of a /tmp race.
		 */
		if ($file_upload_size > 0) {
			if (!is_uploaded_file(safe_file($file_upload))) {
				break;  /* ignore attempt to spoof us; back to composing */
			}
			$attachments_name[] = $file_upload_name;
			$attachments_size[] = $file_upload_size;
			$tmpfile_name = tempnam(dirname(safe_file($file_upload)), 'att.');
			$attachments_file[] = $tmpfile_name;
      
			if (isset ($file_upload_type)) {
				$attachments_type[] = $file_upload_type;
			} else {
				$attachments_type[] = '';
			}
      
			copy (safe_file($file_upload), $tmpfile_name);
			$msg = $message;
		}
    
		$total_size = 0;
		for ($i = 0; $i < count($attachments_size); $i++) {
			$total_size += $attachments_size[$i];
		}
    
		$ACTION_TEXT = $lang->action_add_attach;
		$get_sig = false;
		break;
    
	case DELETE_ATTACHMENT:
		if (isset($attachments_name) && !is_array($attachments_name)) { $attachments = array($attachments_name); }
		if (isset($attachments_size) && !is_array($attachments_size)) { $attachments = array($attachments_size); }
		if (isset($attachments_file) && !is_array($attachments_file)) { $attachments = array($attachments_file); }
		if (isset($attachments_type) && !is_array($attachments_type)) { $attachments = array($attachments_type); }
		if (isset($delattachments) && !is_array($delattachments)) { $indices = array($delattachments); }
    
		if (isset($delattachments) && is_array($delattachments)) {
			for ($i=0; $i<count($delattachments); $i++) {
				for ($j=0; $j<count($attachments_file); $j++) {
					if (strcmp($delattachments[$i], $attachments_file[$j]) == 0) {
						if (!preg_match("|.mime$|", $attachments_file[$j])) {
							unlink (safe_file($attachments_file[$j]));
						}
						$attachments_name[$j] = "";
						$attachments_size[$j] = "";
						$attachments_file[$j] = "";
						$attachments_type[$i] = "";
					}
				}
			}
		}
    
		$new_name = array ();
		$new_file = array ();
		$new_size = array ();
		$new_type = array ();
    
		for ($i=0; $i<count($attachments_file); $i++) {
			if (strcmp($attachments_file[$i], "")) {
				$new_name[] = $attachments_name[$i];
				$new_file[] = $attachments_file[$i];
				$new_size[] = $attachments_size[$i];
				$new_type[] = $attachments_type[$i];
			}
		}
    
		$attachments_name = array ();
		$attachments_file = array ();
		$attachments_size = array ();
		$attachments_type = array ();
    
		$total_size = 0;
    
		for ($i=0; $i<count($new_name); $i++) {
			$attachments_name[] = $new_name[$i];
			$attachments_file[] = $new_file[$i]; 
			$attachments_size[] = $new_size[$i]; 
			$attachments_type[] = $new_type[$i]; 
			$total_size += $attachments_size[$i];
		}
    
		$msg = $message;
		$ACTION_TEXT = $lang->action_del_attach;
		$get_sig = false;
		break;
    
	case BOUNCE_COMPOSE:
		$ACTION_TEXT = $lang->action_bounce;
		break;
    
	case CANCEL:
		$status_result = $lang->status_cancel;
		include "$default->include_dir/generic-header.inc";
		include "$default->include_dir/compose/results.inc";
		include "$default->include_dir/generic-footer.inc";
		exit;
    
	default:
		$ACTION_TEXT = $lang->action_compose;
		break;
	}
}
if (!isset($ACTION_TEXT)) $ACTION_TEXT = $lang->action_compose;
if (!isset($status_sent)) status($lang->status_composition);

$title = $lang->status_composition;
$sidebar = false;
require ("$default->include_dir/generic-header.inc");
if (!$this_client->lynx) {
  $addresses = imp_get_addresses($imp->user, $imp->server);
  include "$default->include_dir/compose/javascript.inc";
  include "./lib/js/open_contacts.js";
}

$from = get_from();

if (!isset($msg)) { $msg = ''; }
if (!isset($to)) { $to = ''; }
if (!isset($cc)) { $cc = ''; }
if (!isset($bcc)) { $bcc = ''; }
if (!isset($subject)) { $subject = ''; }
if ($get_sig && $sig = imp_get_signature($imp->user, $imp->server)) $msg .= "\n\n\n" . $sig;

if (isset($actionID) && ($actionID == BOUNCE_COMPOSE)) {
  if (!$this_client->lynx) {
    include "$default->include_dir/compose/bounce.inc";
  } else {
    include "$default->include_dir/compose/lynx_bounce.inc";
  }
} else {
  if (!$this_client->lynx) {
    include "$default->include_dir/compose/compose.inc";
  } else {
    include "$default->include_dir/compose/lynx_compose.inc";
  }
}
require "$default->include_dir/generic-footer.inc";

?>
