%define version 2.0.10
%define release 1
Summary: Internet webMail Program. Access an IMAP server using HTTP via PHP.
Name: imp
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Applications/Horde
Source: ftp://ftp.horde.org/imp/imp-%{version}.tar.gz
BuildArchitectures: noarch
Buildroot: /tmp/imp-root
Prefix: /home/httpd/html
Requires: Horde

%description
IMP started as a free Hotmail work-alike, and evolved quickly 
from there. It relies on PHP as its language, and uses HTTP and 4th generation 
web browsers as clients. It allows these clients to access email residing on 
IMAP servers via a powerful but intuitive professional-looking user interface.

Optional components include the ability to use a SQL database server to allow 
users to store addressbook information, as well as integration with LDAP to 
allow for directory searching for addressbook information across the enterprise. 
%prep
%setup 

%build

%install
rm -rf $RPM_BUILD_ROOT
mkdir $RPM_BUILD_ROOT
mkdir $RPM_BUILD_ROOT/home/
mkdir $RPM_BUILD_ROOT/home/httpd/
mkdir $RPM_BUILD_ROOT/home/httpd/html/
mkdir $RPM_BUILD_ROOT/home/httpd/html/horde/
mkdir $RPM_BUILD_ROOT/home/httpd/html/horde/imp/
cp -R * $RPM_BUILD_ROOT/home/httpd/html/horde/imp/

# IMP Items from horde install.sh script
touch $RPM_BUILD_ROOT/home/httpd/html/horde/imp/config/defaults.php3
chmod 777 $RPM_BUILD_ROOT/home/httpd/html/horde/imp/config/defaults.php3
touch $RPM_BUILD_ROOT/home/httpd/html/horde/imp/lib/db.lib
chmod 777 $RPM_BUILD_ROOT/home/httpd/html/horde/imp/lib/db.lib
touch $RPM_BUILD_ROOT/home/httpd/html/horde/imp/lib/imp.lib
chmod 777 $RPM_BUILD_ROOT/home/httpd/html/horde/imp/lib/imp.lib
touch $RPM_BUILD_ROOT/home/httpd/html/horde/imp/lib/mimetypes.lib
chmod 777 $RPM_BUILD_ROOT/home/httpd/html/horde/imp/lib/mimetypes.lib
touch $RPM_BUILD_ROOT/home/httpd/html/horde/imp/lib/mimetypes.lib

%clean
if [ "$RPM_BUILD_ROOT" != "/" ] ; then
        rm -rf $RPM_BUILD_ROOT
fi

%post

rm -rf $RPM_BUILD_ROOT

%preun

%files
%defattr(-,nobody,nobody)
# Include these dir's as a %dir so not all files are sucked in
%dir /home/httpd/html/horde/imp/
# Include these dirs so that all files _will_ get sucked in
/home/httpd/html/horde/imp/graphics/
/home/httpd/html/horde/imp/lib/
/home/httpd/html/horde/imp/locale/
/home/httpd/html/horde/imp/scripts/
/home/httpd/html/horde/imp/templates/
# Include other files in the imp dir
# Most of these, ie CHANGES COPYING etc., should be in a %docs
# directive, but we wouldn't be relocatable if we did that.
/home/httpd/html/horde/imp/CHANGES
/home/httpd/html/horde/imp/COPYING
/home/httpd/html/horde/imp/CREDITS
/home/httpd/html/horde/imp/DATABASE
/home/httpd/html/horde/imp/FAQ
/home/httpd/html/horde/imp/HELP
/home/httpd/html/horde/imp/TODO
/home/httpd/html/horde/imp/*.php3
/home/httpd/html/horde/imp/*.html

%config /home/httpd/html/horde/imp/config/ 
%doc 

%changelog
* Mon Aug 02 1999 Dale Lovelace <dale@redhat.com>
- up to 2.0.10

* Fri Jul 09 1999 Dale Lovelace <dale@redhat.com>
- up to 2.0.9

* Thu Jul 08 1999 Dale Lovelace <dale@redhat.com>
- up to 2.0.8
- Clean up build root

* Mon May 24 1999 Dale Lovelace <dale@redhat.com>
- Took out some typo's that added some module info to Horde
- Made the RPM noarch
- Added %defattr(-,nobody,nobody)

* Sat May 22 1999 Dale Lovelace <dale@redhat.com>
- Updated to imp-2.0.4
- Now we create a modules file in the HORDE/config directory
- Fixed a few typos

* Tue May 18 1999 Dale Lovelace <dale@redhat.com>
- Add new Summary: and %description from Mike Hardy <mike@itsprojects.com> 

* Tue May 04 1999 Dale Lovelace <dale@redhat.com>
- Make relocatable prefix=/home/httpd/html
- Run install.sh stuff to set perm's etc.
- Add imp/config dir files as %config

* Fri Apr 30 1999 Dale Lovelace <dale@redhat.com> 
- Build first RPM

