/* IMP database creation script for Sybase */

/* (c) Mike Hardy, 1999 released under the GPL */
/* see the file COPYING in this distribution for license info */

/* To initialize the Sybase ASE SQL Server for IMP do this: */
/* <prompt>% isql -i sybase_create.sql -U<username> -P<password> */

set nocount on

/* I assume you have already created the database "horde" */
/*use horde*/
/*go*/

IF EXISTS (SELECT * FROM imp.dbo.sysobjects WHERE name = "Imp_Pref")
BEGIN
DROP TABLE Imp_Pref
END
GO

CREATE TABLE Imp_Pref (
       User	      VARCHAR(255) NOT NULL,
       Sig	      TEXT,
       FullName	      VARCHAR(70),
       ReplyTo	      VARCHAR(70),
       Lang	      VARCHAR(70)
)
GO

IF EXISTS (SELECT * FROM imp.dbo.sysobjects WHERE name = "Imp_Addr")
BEGIN
DROP TABLE Imp_Addr
END
GO

CREATE TABLE Imp_Addr (
       User	      VARCHAR(255) NOT NULL,
       Address	      VARCHAR(255),
       NickName	      VARCHAR(255),
       FullName	      VARCHAR(255)
)
GO

IF EXISTS (SELECT * FROM imp.dbo.sysobjects WHERE name = "Imp_Log")
BEGIN
DROP TABLE Imp_Log
END
GO

CREATE TABLE Imp_Log (
       User	      VARCHAR(255) NOT NULL,
       TS	      DATETIME,
       Event	      INTEGER,
       Target	      VARCHAR(255),
       Log	      VARCHAR(255),
       MD5	      VARCHAR(255)
)
GO

GRANT Select,Insert,Update,Delete ON Imp_Pref,Imp_Addr,Imp_Log TO nobody
