<?php

/*
  
  File: config/mime.conf
  $Author: chuck $
  $Revision: 2.2.2.5 $
  $Date: 2000/01/19 19:53:58 $
  
  IMP: Copyright 1998 Patrick C. Audley <paudley@blackcat.ca>
                 1999 The Horde Project <dev@horde.org>
  
  This code is under the GNU Public License
  See the file COPYING in this directory
  
*/


/* MIME Type Configuration
 *
 * This file allows you to configure site-specific MIME types, and
 * control how HTML email is rendered by IMP. Please read the comments
 * carefully if you change it.  */


/* If you would like IMP to handle HTML email, please examine the last 3 examples */


/* If you're adding your own type, each entry is an array, and here
 * are what the parts control:
 *
 * $mime_actions['type/subtype'] tells the MIME engine what type the array is for
 *
 * 'action':        Determines whether a special driver needs to be called for this type.
 *                   These drivers are implemented in the mimetypes.lib file. Usually 'default'.
 *
 * 'view':          Determines whether the MIME type is viewable in a stand-alone window
 *                   (This is useful for large things like Word documents via mswordview)
 *
 * 'inline':        Determines whether IMP should display the type in the main message window
 *                   (This is useful for images or HTML or other small things)
 *
 * 'override_text': Determines if this MIME-type will display *in place of* other MIME types.
 *                   This option is not necessarily safe, but can be used well for things like
 *                   displaying HTML parts of email without the non-Rich part. (optional)
 *
 * 'download':      Determines whether the MIME-type is separately downloadable from IMP
 *                   (This is useful for almost everything, like documents, etc)
 *
 * 'icon':          Which icon to use for this MIME-type, icons in <imphome>/graphics (optional)
 *
 * 'view_function': The name of any special MIME-driver needed to view this MIME-type (optional)
 *
 * 'function':      The name of any special MIME-driver needed to download this MIME-type.
 *                   This is required only if 'action' is set to 'function'.
 */

/* For example, The first function is a generic text formatter. It
 * will take a MIME type that is actually text (like application/pgp)
 * and format it.
 *
 * The second function below display all gifs/jpgs that are 10k or
 * smaller.
 *
 * The third function will display word attachments if you have
 * mswordview. */

/********* The last section controls HTML-mail behavior *********** */

$mime_actions['application/pgp'] =
array(
      'action'          => 'default',
      'view'            => true,
      'inline'          => true,
      'view_function'   => 'mime_view_text',
      'download'        => true,
      'icon'            => 'mime_text.gif'
      );

$mime_actions['application/octet-stream/delivery-status'] =
array(
      'action'          => 'default',
      'view'            => true,
      'inline'          => true,
      'view_function'   => 'mime_view_text',
      'download'        => true,
      'icon'            => 'mime_mail.gif'
      );

$mime_actions['application/octet-stream/rfc822'] =
array(
      'action'          => 'default',
      'view'            => true,
      'inline'          => true,
      'view_function'   => 'mime_view_text',
      'download'        => true,
      'icon'            => 'mime_mail.gif'
      );

$mime_actions['message/rfc822'] =
array(
      'action'          => 'default',
      'view'            => true,
      'inline'          => false,
      'view_function'   => 'mime_view_text',
      'download'        => true,
      'icon'            => 'mime_mail.gif'
      );

$mime_actions['message/'] =
array(
      'action'          => 'default',
      'view'            => true,
      'inline'          => true,
      'view_function'   => 'mime_view_text',
      'download'        => true,
      'icon'            => 'mime_mail.gif'
      );

$mime_actions['text/rfc822'] =
array(
      'action'          => 'default',
      'view'            => true,
      'inline'          => true,
      'view_function'   => 'mime_view_text',
      'download'        => true,
      'icon'            => 'mime_mail.gif'
      );

$mime_actions['text/rfc822-headers'] =
array(
      'action'          => 'default',
      'view'            => true,
      'inline'          => true,
      'view_function'   => 'mime_view_text',
      'download'        => true,
      'icon'            => 'mime_mail.gif'
      );

$mime_actions['image/'] =
array(
      'action'       => 'default',
      'function'     => 'mime_action_images',
      'view'         => true,
      'download'     => true,
      'icon'         => 'mime_image.gif'
      );

$mime_actions['application/msword'] =
array(
      'action'       => 'default',
      'view'         => true,
      'view_function' => 'mime_view_msword',
      'download'     => true,
      'icon'         => 'mime_msword.gif'
      );

$mime_actions['application/x-imp-data'] =
array(
      'action'       => 'function',
      'function'     => 'mime_action_ximpdata',
      'view'         => false,
      'download'     => false,
      'icon'         => 'mime_broken.gif'
      );

$mime_actions['application/x-gtar'] =
array(
      'action'          => 'default',
      'view'            => true,
      'view_function'   => 'mime_view_tgz',
      'download'        => true,
      'icon'            => 'mime_compressed.gif'
      );

$mime_actions['application/x-tar'] =
array(
      'action'          => 'default',
      'view'            => true,
      'view_function'   => 'mime_view_tar',
      'download'        => true,
      'icon'            => 'mime_compressed.gif'
      );


/*** User-contributed mimetypes for various kinds of data. Uncomment
     them if you want them. ***/

// .zip - Uses zipinfo.
// By: Joao Pedro Goncalves <joaop@iscsp.utl.pt>
// Define $default->path_to_unzip in defaults.php3.
/*
$mime_actions['application/zip'] =
array(
      'action'          => 'default',
      'view'            => true,
      'view_function'   => 'mime_view_zip',
      'download'        => true,
      'icon'            => 'mime_compressed.gif'
      ); */


// .rpm - RedHat packages.
// By: Joao Pedro Goncalves <joaop@iscsp.utl.pt>
// Define $default->path_to_rpm in defaults.php3.
/*
$mime_actions['/x-pn-realaudio-plugin'] =
array(
      'action'          => 'default',
      'view'            => true,
      'view_function'   => 'mime_view_rpm',
      'download'        => true,
      'icon'            => 'mime_rpm.gif'
      );
*/

// .deb - Debian packages.
// Define $default->path_to_dpkg in defaults.php3.
/*
$mime_actions['/x-debian-package'] =
array(
      'action'          => 'default',
      'view'            => true,
      'view_function'   => 'mime_view_deb',
      'download'        => true,
      'icon'            => 'mime_deb.gif'
      );
*/  


/***** HTML Email Configuration *****/

// There are multiple ways to configure IMP to view HTML sent as
// email. Here are three. It is VERY IMPORTANT to note that if you
// configure HTML to be viewed inline, it will OVERRIDE the text part
// of the email and replace it with the HTML part. This follows the
// behavior of most "Rich" email clients that send HTML mail with a
// text and HTML part that are identical except for the markup.

// If you don't uncomment any of these sections, HTML parts are viewed
// just like any other attachment.

// Allow the HTML MIME-part to be viewed in another browser window and
// downloadable. This is the safest way to read mail and
// still have HTML mail renderable, all options are open.
//
// Viewing HTML is not secure though - it can open you to attack. For 
// this reason, you can *choose* to view it, but it won't display inline
// unless you change the settings.
//
$mime_actions['text/html'] =
array(
      'action'          => 'default',
      'view'            => true,
      'inline'          => false,
      'override_text'   => false,
      'view_function'   => 'mime_view_html',
      'download'        => true,
      'icon'            => 'mime_html.gif'
      );

// View the HTML MIME-part inline, overriding the text part, and be
// downloadable. This is not provably 100% safe (you may lose text).
//
// This is not secure, unfortunately, and should only be used if you
// can trust your incoming mail.
/*
$mime_actions['text/html'] =
array(
      'action'          => 'default',
      'view'            => true,
      'inline'          => true,
      'override_text'   => true,
      'view_function'   => 'mime_view_html',
      'download'        => true,
      'icon'            => 'mime_html.gif'
      );
*/

// This is my (mikeh@spark.com) favorite - HTML inline, not
// downloadable. Overrides text parts. Totally transparent. This is
// just like the previous one, but the user interface is less
// cluttered without the download option. There is the potential
// danger that we lose some text parts when we do this, but current
// HTML-email clients send the email in such a way that this doesn't
// happen as far as I know.
// 
// Unfortunately, this is not secure. Unless you only get trusted mail, (like an
// intranet, where I have my IMP), you shouldn't use this.
/*
$mime_actions['text/html'] =
array(
      'action'          => 'default',
      'view'            => true,
      'inline'          => true,
      'override_text'   => true,
      'view_function'   => 'mime_view_html',
      'download'        => false,
      'icon'            => 'mime_html.gif'
      );
*/

?>
