<?php

/*
  
  File: poppassd.php3
  Author: oliver
  Revision: 1.0
  Date: 1999/01/04
  
  Copyright 1999, 2000 Oliver M. Bolzer <oliver@gol.com>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/

if (!defined('HORDE_LIB')) include '../lib/horde.lib';
require './lib/imp.lib';           /* IMPlib is the IMP function library  */
require '../config/horde.php3';
require './config/defaults.php3';  /* Defaults configuration file */
require './config/html.php3';
error_reporting($default->error_level);
$language = select_lang();
require "./locale/$language/passwd.lang";
require './locale/local/passwd.lang';


/* add help in future */
/* require "./help/defines/passwd.help"; */

/* read the current session; exit if there isn't a valid one */
page_open(array('sess' => 'HordeSession'));
page_close();
if (!isset($imp) || !is_object($imp)) { header("Location: login.php3?reason=logout"); exit; }
$imp->unpickle();

/* doctype */
require "$default->include_dir/doctype.inc";


/* Get the poppassd server from defaults, otherwise set to safe values */
if (isset($default->poppassd_server))
{ 
	$poppassd_server = $default->poppassd_server;
	if (isset($default->poppassd_port))
	{
		$poppassd_port = $default->poppassd_port;
	}
	else
	{
		$poppassd_port = 106;
	}
}
else
{
	$poppassd_server = '/dev/null';
	$poppassd_port   = 0;
}


/* run through ActionIDs */
if (isset($actionID)) {
  switch ($actionID) {
  case NO_ACTION:
    break;
    
  case PASSWD_INPUT:
    include "$default->include_dir/passwd/poppassd_input.inc";
    break;
    
  case PASSWD_DISALLOW:
    $errortype = 'nopermission';
    include "$default->include_dir/passwd/poppassd_error.inc";
    break;
    
  case PASSWD_CHANGE:	        /* now we change the passwd */
    /* error checking */
    if (!($username == $imp->user)) {
      $errortype = 'username';
      include "$default->include_dir/passwd/poppassd_error.inc";
    }
    if (strcmp($old_pass, $imp->pass) != 0) {
      $errortype = 'old_pass';
      include "$default->include_dir/passwd/poppassd_error.inc";
    }
    if (strlen($new_pass) <= 4) {
      $errortype = 'short_pass';
      include "$default->include_dir/passwd/poppassd_error.inc";
    }
    if (strcmp($new_pass, $new_pass2) != 0) {
      $errortype = 'new_pass_ne';
      include "$default->include_dir/passwd/poppassd_error.inc";
    }
    
    /* OK, the input data seems to be OK, connect */
    $passd = fsockopen($poppassd_server, $poppassd_port, &$errno, &$errstr);
    if (!$passd){
      $errortype = "Password Server: $errno($errstr)";
      include "$default->include_dir/passwd/poppassd_error.inc";
    } else {
      $input = fgets($passd, 128);
      if (!(substr($input, 0, 3) == 200)) {
	fclose($passd);
	$errortype = 'no_connect';
	include "$default->include_dir/passwd/poppassd_error.inc" ;
      }
      $output = 'user ' . $imp->user . "\n";
      fputs($passd,$output);
      
      $input = fgets($passd, 128);
      if (!(substr($input, 0, 3) == 200)) {
	fclose($passd);
	$errortype = $input;
	include "$default->include_dir/passwd/poppassd_error.inc";
      }
      $output = "pass " . $imp->pass . "\n";
      fputs($passd,$output);
      
      $input = fgets($passd, 128);
      if (!(substr($input, 0, 3) == 200)) {
	fclose($passd);
	$errortype = $input;
	include "$default->include_dir/passwd/poppassd_error.inc";
      }
      $output = "newpass $new_pass\n";
      fputs($passd,$output);
      
      $input = fgets($passd, 128);
      if (!(substr($input, 0, 3) == 200)) {
	fclose($passd);
	$errortype = $input;
	include "$default->include_dir/passwd/poppassd_error.inc";
      }
      $output = "quit\n";
      fputs($passd, $output);
      
      
      $input = fgets($passd, 128);
      if (!(substr($input, 0, 3) == 200)) {
	fclose($passd);
	$errortype = $input;
	include "$default->include_dir/passwd/poppassd_error.inc";
      }
      fclose($passd);
      
      /* yeah, password changed, user must re-login */
      echo '<script language=javascript>
            window.location="login.php3?reason=chpass";
            </script>';
      exit;
    }
    break;
    
  default:
    include "$default->include_dir/passwd/poppassd_input.inc";
  }
} else {
  include "$default->include_dir/passwd/poppassd_input.inc";
}

?>
