<?php

error_reporting(E_ALL);

/*
  
  File: view.php3
  $Author: chuck $
  $Revision: 2.8.2.7 $
  $Date: 1999/10/18 14:55:51 $
  
  IMP: Copyright 1998, 1999 Charles J. Hagenbuch <chuck@horde.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/

// if $id=2.1, returns $structure->parts[1]->parts[0]
function partFromId ($structure, $id) {
  $res = $structure;
  if (isset($res->parts[0])) {
    $piece = explode('.', $id);
    $num = count($piece);
    $ind = 0;
    $j = 0;
    while ($j < $num) {
      $ind = $piece[$j]-1;
      if (isset($res->parts[$ind]))
	$res = $res->parts[$ind];
      $j++;
    }
  }
  return $res;
}


$need_horde_db = 0;
$db_lib_loaded = 0;
if (!defined("HORDE_LIB")) include '../lib/horde.lib';
require './lib/imp.lib';           /* IMPlib is the IMP function library  */
require './lib/mimetypes.lib';     /* Mime functions */
require './config/defaults.php3';  /* Defaults configuration file */
require './config/html.php3';
require './config/mime.php3';

error_reporting($default->error_level);  /* set error level from imp.lib   */
set_time_limit($default->max_execution_time);

page_open(array('sess' => 'HordeSession'));
page_close();
if (!isset($imp) || !is_object($imp)) header("Location: login.php3?reason=logout");
$imp->unpickle();
$imp->authenticate();

$structure = imap_fetchstructure ($imp->stream, imap_msgno($imp->stream, $index));  
if (($actionID != SAVE_MESSAGE) && ($actionID != VIEW_SOURCE)) $part = partFromId($structure,$bodypart);

/* Run through action handlers */
if (isset($actionID)) {
  switch($actionID) {
  case NO_ACTION:
    break;
    
  case DOWNLOAD_ATTACH:
    $mime = new mime_part_data;
    $mime->parse($part);
    
    header('Content-Disposition: attachment; filename="' . $mime->name .'"');
    header('Content-type: application/RFC822');    /* This should force a save file dialog...  */
    break;
    
  case VIEW_ATTACH:
    $mime = new mime_part_data;
    $mime->parse($part);
    $mime->set_imap_data($index, $bodypart );
    header("Content-Disposition: inline; filename=$mime->name");
    if (isset($mime->action['view_function'])) {
      header('Content-type: text/html');
      $title = 'MIME Attachment View';
      include "$default->include_dir/generic-header.inc";
      eval('echo ' . $mime->action['view_function'] . '($mime);');
      include "$default->include_dir/generic-footer.inc";
      exit;
    }
    
    if (($mime->subtype == 'jpeg') || ($mime->subtype == 'gif') || ($mime->subtype == 'png') || ($mime->subtype == 'pjpeg')) {
      header("Content-type: image/$mime->subtype");
    } else {
      /* do not set the encoding type to 1 here because it potentially
       * blows away our shot at decoding the attachment when we need
       * to.  $mime->encoding = 1; */
      header('Content-type: text/plain');
    }
    break;
    
  case VIEW_SOURCE:
    header('Content-type: text/plain');
    header('Content-Disposition: inline; filename="Message Source"');
    echo imap_fetchheader ($imp->stream, imap_msgno($imp->stream, $index)) . "\n" . imap_body ($imp->stream, $index, FT_UID );
    exit; 
    break;
    
  case SAVE_MESSAGE:
    $h = imap_header($imp->stream, imap_msgno($imp->stream, $index));
    $mime = new mime_part_data;
    
    if (isset($h->subject))
      $mime->name = chop(decode_mime_string($h->subject));
    else
      $mime->name = 'message';
    
    $from = trim(decode_mime_string($h->fromaddress));
    $msg = 'From ' . $from . "\n";
    $msg = $msg . imap_fetchheader($imp->stream, $index, FT_PREFETCHTEXT|FT_UID);
    $body = $msg . imap_body ($imp->stream, $index, FT_UID);
    
    header('Content-Disposition: attachment; filename="' . $mime->name . '"');
    header('Content-type: application/RFC822');
    break;
    
  }
}

if (isset($actionID) && $actionID == VIEW_ATTACH) {
  header('Content-Disposition: inline; filename="' . $mime->name . '"');
}

if ($actionID != SAVE_MESSAGE) {
  $body = imap_fetchbody($imp->stream, $index, $bodypart, FT_UID);
  
  if ($mime->encoding == ENCBASE64)
    $body = imap_base64($body);
  else if ($mime->encoding == ENCQUOTEDPRINTABLE && ($qprint_msg = imap_qprint($body)))
    $body = $qprint_msg;
}

echo $body;

?>
