<?php

/*
 
 File: spelling.php3
 $Author: chuck $
 $Revision: 2.2.2.5 $
 $Date: 2000/01/06 02:17:34 $
 
 IMP: Copyright 1999 Charles J. Hagenbuch  <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */

function estrtok (&$token, &$delim, $string, $separators) {
  static $lastString = '';
  static $stringLen = 0;
  
  if ($lastString != $string) {
    $lastString = $string;
    $stringLen = strlen($string);
    $aStrTok = strtok($string, $separators);
    $stringLen -= strlen($aStrTok) + 1;
  } else {
    $aStrTok = strtok($separators);
    $stringLen -= strlen($aStrTok) + 1;
  }
  
  $token = $aStrTok;
  $pos = strlen($string) - $stringLen - 1;
  if ($pos < strlen($string))
    $delim = $string[$pos];
  else
    $delim = '';
  
  if (!$aStrTok)
    return $stringLen>=0;
  else
    return true;
}

function member ($string, $array) {
  while (list($key, $val) = each($array)) {
    if ($val == $string)
      return true;
  }
  return false;
}


$need_horde_db = 0;
$db_lib_loaded = 0;
if (!defined("HORDE_LIB")) include '../lib/horde.lib';
require './lib/imp.lib';             /* IMPlib is the IMP function library  */
require './config/defaults.php3';    /* Defaults configuration file */

/* Html styles configuration */
require './config/html.php3';

$language = select_lang();
require "./locale/$language/spelling.lang";
require './locale/local/spelling.lang';
require './config/lang.php3';

error_reporting($default->error_level); /* set error level from imp.lib   */

$title = $lang->spelling_title;
$sidebar = false;
require "$default->include_dir/doctype.inc";
require "$default->include_dir/generic-header.inc";

if (isset($default->ispell_lang) && isset($spell_lang)) {
  $spell_opt = $default->ispell_lang[$spell_lang];
} else {
  $spell_opt = '';
}

$message = stripSlashes($message);

// special traitement depending on language (quotes are not equally treated by
// ispell in english and in french)
switch ($spell_lang) {
 case "fr":
   // $tocheck = str_replace("'", "\\'", escapeShellCmd($message));
   // break;
 default:
   $tocheck = strtr($message, "\n", ' ');
   $tocheck = escapeShellCmd($tocheck);
}

exec("echo $tocheck | $default->path_to_ispell $spell_opt  -l", $warnings);
sort($warnings);

$prev = '';
while (list($key, $val) = each($warnings)) {
   if ($val != $prev) {
      $errors[] = $val;
   }
   $prev = $val;
}

$message = htmlspecialchars($message);

if (isset($errors)) {
  $msg = '';
  while (estrtok($tok, $delim, $message, " ,.:;'\"&%!?()[]{}/|\n\\")) {
    if (member($tok, $errors))
      $msg .= "<font color=\"ff0000\">$tok</font>$delim";
    else
      $msg .= $tok . $delim;
  }
  echo nl2br($msg);
} else {
  echo $lang->no_errors;
}

require "$default->include_dir/spelling/footer.inc";

?>
