<?php

/*
 
 File: login.php3
 $Author: chuck $
 $Revision: 2.10.2.5 $
 $Date: 1999/11/07 04:08:22 $
 
 IMP: Copyright 1999 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
*/

$need_horde_db = 0;
$db_lib_loaded = 0;
require '../lib/horde.lib';
require './lib/imp.lib';
require './config/defaults.php3';
require '../config/horde.php3';

/* Html styles configuration */
require './config/html.php3';

if (!isset($language)) { $language = select_lang(); }

require "./locale/$language/login.lang";
require './locale/local/login.lang';
$help_file = 'login.help';
require "./locale/defines/$help_file";

$this_client = new WebClient;
error_reporting($default->error_level);
if (!isset($reason)) { $reason = 'login'; }

/* if there is an existing session, redirect to the mailbox */
page_open(array('sess' => 'HordeSession'));
if (isset($imp) && is_object($imp)) {
  if ($reason == 'logout' || $reason == 'timeout') {
    $sess->unregister('imp');
    $sess->delete();
  }
  else { header('Location: ' . $sess->url('mailbox.php3')); exit; }
}
page_close();

$langs = '<select name="new_lang" onchange="selectLang()">';
while (list($key, $val) = each($lang->lang)) {
   if ($key == $language) $sel = ' SELECTED';
   else $sel = '';
   $langs .= "<option value=\"$key\"$sel>$val</option>\n";
}
$langs .= '</select>';

if ($default->log_stats) {
	openlog($default->log_ident, LOG_PID, $default->log_stats_facil);
	syslog($default->log_prio, "login.php3 $REMOTE_ADDR $reason");
	closelog();
}

require "$default->include_dir/doctype.inc";

status($lang->welcome_to_imp);
if (!$this_client->lynx) {
    include("$default->include_dir/login/login.inc");
} else {
    include("$default->include_dir/login/login_lynx.inc");
    include_lynx_menu(IMPMENU_BLANK); /* Menu Mode = IMPMENU_BLANK */
}

include './config/MOTD.html';
include "$default->include_dir/generic-footer.inc";

if (isset($imp)) page_close();

?>
