<?php

/*
  
  File: mailbox.php3
  $Author: chuck $
  $Revision: 2.29.2.20 $
  $Date: 1999/10/05 20:53:45 $
  
  IMP: Copyright 1999 Charles J. Hagenbuch <chuck@horde.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/


/* array of months for faster/cleaner code */
$Months = array('jan' => '01',
		'feb' => '02',
		'mar' => '03',
		'apr' => '04',
		'may' => '05',
		'jun' => '06',
		'jul' => '07',
		'aug' => '08',
		'sep' => '09',
		'oct' => '10',
		'nov' => '11',
		'dec' => '12');

/* display_toaddress: check the user's address and list of addresses that To: should be displayed for */
function display_toaddress ($user, $server, $from) {
   return is_int(strpos($from, get_barefrom($user, $server)));
}

function messageRange ($arr, $index, $offset, $beginIndex) {
  $count = 200; // maybe make this configurable later
  $half = $count/2;
  if ($index < $half) $start = 0;
  else if (($index + $count) >= count($arr)) $start = max(0, count($arr) - $count);
  else $start = $index - $half;
  $end = min($start + $count, count($arr));
  $new = array();
  for ($i = $start; $i < $end; $i++) {
    $new[] = $arr[$i];
  }
  $offset = $start;
  $beginIndex = $index - $start - 1;
  return $new;
}


$need_horde_db = 1;
$db_lib_loaded = 0;
if (!defined("HORDE_LIB")) include '../lib/horde.lib';
if (!defined("IMP_LIB")) include './lib/imp.lib';
require './lib/mimetypes.lib';
require './config/defaults.php3';

/* Html styles configuration */
require './config/html.php3';
/* Mailbox configuration */
require './config/mailbox.php3';
/* include mime and language configuration */
require './config/mime.php3';

if (isset($new_lang)) {
  $language = $new_lang;
} else {
  $language = select_lang();
}
require "./locale/$language/mailbox.lang";
require './locale/local/mailbox.lang';

$this_client = new WebClient;
error_reporting($default->error_level);

/* Set or read session */
page_open(array('sess' => 'HordeSession'));
if (isset($actionID) && $actionID == IMP_LOGIN) {
  $imp = new ImpSession();
  $imp->construct();
  $sess->register('imp');
} else if (!isset($imp) || !is_object($imp)) {
  page_close();
  header('Location: ' . $sess->url('login.php3'));
  exit;
} else {
  $imp->unpickle();
}

/* only proceed on a valid login */
$imp->authenticate();

/* indicates invalid login or expired login so skip all the crap below */
if (isset($imp->stream) && (!$imp->stream)) exit;
if (!isset($plural)) $plural = false;

$delnum = 0;

/* Run through the action handlers */

$status_string = '';
$status_color = 'green';

if (isset($actionID)) {
  if (isset($indices) && !is_array($indices)) { $indices = Array($indices); }
  
  switch ($actionID) {
  case NO_ACTION:
    $status_string = $lang->mailbox . $imp->label;
    break;
    
  case DELETE_MESSAGES:
    if (isset($indices) && $indices && $imp->mailbox) {
      for ($i = 0; $i < count($indices); $i++) {
	if (!(imap_delete($imp->stream, imap_msgno($imp->stream, $indices[$i])))) {
	  $status_string = $lang->error($imp->label, 'deletion');
	  $status_color = 'red';
	}
      }
      if (!$status_string) {
	if ($i != 1) $plural = true;
	$status_string = $lang->success1($imp->label, 'deleted', $i, $plural);
      }
    }
    if (!$status_string) {
      $status_string = $lang->error($imp->label, 'deletion');
      $status_color = 'red';
    }
    break;
    
  case UNDELETE_MESSAGES:
    if (isset($indices) && $imp->mailbox && $indices) {
      for ($i = 0; $i < count($indices); $i++) {
	if (!(imap_undelete($imp->stream, imap_msgno($imp->stream, $indices[$i])))) {
	  $status_string = $lang->error($imp->label, 'undeletion');
	  $status_color = 'red';
	}
      }
      if (!$status_string) {
	if ($i != 1) $plural = true;
	$status_string = $lang->success1($imp->label, 'undeleted', $i, $plural);
      }
    }
    if (!$status_string) {
      $status_string = $lang->error($imp->label, 'undeletion');
      $status_color = 'red';
    }
    break;
    
  case MOVE_MESSAGES:
    if (isset($indices) && isset($targetMbox) && $targetMbox && $indices) {
      $msg_list = implode($indices, ',');
      if (! (imap_mail_copy($imp->stream, $msg_list, $targetMbox, CP_UID|CP_MOVE)) ) {
	$status_string = $lang->error($imp->label, 'move');
	$status_color = 'red';
      } else {
	if (count($indices) != 1) $plural = true;
	$status_string = $lang->success2($imp->label, $targetMbox, 'moved', count($indices), $plural);
      }
    }
    if (!$status_string) {
      $status_string = $lang->error($imp->label, 'move');
      $status_color = 'red';
    }
    break;
    
  case COPY_MESSAGES:
    if (isset($targetMbox) && isset($indices) && $targetMbox && $indices) {
      $msg_list = implode($indices, ',');
      if (!(imap_mail_copy($imp->stream, $msg_list, $targetMbox, CP_UID)) ) {
	$status_string = $lang->error($imp->label, 'copy');
	$status_color = 'red';
      } else {
	if (count($indices) != 1) $plural = true;
	$status_string = $lang->success2($imp->label, $targetMbox, 'copied', count($indices), $plural);
      }
    }
    if (!$status_string) {
      $status_string = $lang->error($imp->label, 'copy');
      $status_color = 'red';
    }
    break;
    
  case HIDE_DELETED:
    $imp->delhide = (!$imp->delhide);
    if ($imp->delhide) {
      $status_string = $lang->hiding_deleted;
    } else {
      $status_string = $lang->showing_deleted;
    }
    break;
    
  case EXPUNGE_MAILBOX:
    if ($imp->mailbox) {
      if (!(imap_expunge($imp->stream))) {
	$status_string = $lang->error($imp->label, 'expunge');
	$status_color = 'red';
      } else {
	$status_string = $lang->mailbox . ': ' . $imp->label . ': ' . $lang->expunged;
      }
    }
    if (!$status_string) {
      $status_string = $lang->error($imp->label, 'expunge');
      $status_color = 'red';
    }
    break;
    
  case IMP_LOGIN:
    $status_string = $lang->mailbox . ': ' . $imp->label;
    if (isset($new_lang)) {
      $imp->setLang($new_lang);
      $language = $new_lang;
    }
    if ($default->log_stats || $default->log_auth) {
      openlog($default->log_ident, LOG_PID, $default->log_stats_facil);
      if ($default->log_stats)
	syslog($default->log_prio, "mailbox.php3 $REMOTE_ADDR login SUCCESS $server:$port $imp->user $language");
      if ($default->log_auth)
	syslog($default->log_prio | $default->log_auth_facil, "Login $REMOTE_ADDR to $server:$port as $imp->user");
      closelog();
    }
    break;
  }
  
} else $status_string = $lang->mailbox . ': ' . $imp->label;


if ($default->user_use_folders) {
  $options = mailbox_list(true);
}

$check = imap_check($imp->stream);

$sidebar = false;
require "$default->include_dir/doctype.inc";
require "$default->include_dir/generic-header.inc";
$nummsgs = $check->Nmsgs;  /* removed call to imap_num_msgs - cbj */

if ($nummsgs > $default->max_messages_page) {
  $page_count = ceil($nummsgs/$default->max_messages_page);
  
  /* Figure out which page to display */
  if (isset($page) && $page) {                           /* make sure we're not past the end */
    if ($page > $page_count) $page = $page_count;
  } else if (isset($start) && $start) {                  /* messages set this when returning to a mailbox */
    $page = ceil($start/$default->max_messages_page);
  } else if (function_exists('imap_search')) {           /* try and use imap_search to find the first unread message */
    $new = imap_search($imp->stream, 'UNSEEN');
    if ($new) {
      if ($imp->sortdir)
	$page = $page_count - ceil((max($new) + 1)/$default->max_messages_page) + 1;
      else
	$page = ceil(min($new)/$default->max_messages_page);
    } else {
      if ($imp->sortdir) $page = 1;
      else $page = $page_count;
    }
  } else {
    if ($imp->sortdir) $page = 1;
    else $page = $page_count;
  }
  $begin = ($page - 1) * $default->max_messages_page + 1;
  $end = $begin + $default->max_messages_page - 1;
  if ($end > $nummsgs) { $end = $nummsgs; }
  
  if ($page == 1) {
    if (!$this_client->lynx) {
      $pages_first = "<img src=\"$default->graphics_url/first-grey.gif\" border=\"0\" alt=\"\">";
      $pages_prev  = "<img src=\"$default->graphics_url/prev-grey.gif\" border=\"0\" alt=\"\">";
    } else {
      $pages_first = '';
      $pages_prev  = '';
    }
  } else {
    $prev             = $page - 1;
    $target_first_url = $sess->url("$default->root_url/mailbox.php3?page=1");
    $target_prev_url  = $sess->url("$default->root_url/mailbox.php3?page=$prev");
    if (!$this_client->lynx) {
      $pages_first = "<a href=\"$target_first_url\"><img src=\"$default->graphics_url/first.gif\" border=\"0\" alt=\"first page\"></a>";
      $pages_prev  = "<a href=\"$target_prev_url\"><img src=\"$default->graphics_url/prev.gif\" border=\"0\" alt=\"prev page\"></a>";
    } else {
      $pages_first = "<a href=\"$target_first_url\">&lt;&lt; [ First Page ]";
      $pages_prev  = "<a href=\"$target_prev_url\">&lt; [ Previous Page ]</a>";
    }
  }
  
  if ($page == $page_count) {
    if (!$this_client->lynx) {
      $pages_last = "<img src=\"$default->graphics_url/last-grey.gif\" border=\"0\" alt=\"\">";
      $pages_next = "<img src=\"$default->graphics_url/next-grey.gif\" border=\"0\" alt=\"\">"; 
    } else {
      $pages_last = '';
      $pages_next = '';
    }
  } else {
    $next = $page + 1;
    $target_last_url = "$default->root_url/mailbox.php3?page=$page_count";
    $target_next_url = "$default->root_url/mailbox.php3?page=$next";
    
    if (!$this_client->lynx) {
      $pages_last = "<a href=\"$target_last_url\"><img src=\"$default->graphics_url/last.gif\" border=\"0\" alt=\"last page\"></a>";
      $pages_next = "<a href=\"$target_next_url\"><img src=\"$default->graphics_url/next.gif\" border=\"0\" alt=\"next page\"></a>";
    } else {
      $pages_last = "<a href=\"$target_last_url\">[ Last Page ] &gt;&gt;</a>";
      $pages_next = "<a href=\"$target_next_url\">[ Next Page ] &gt;</a>";
    }
  }
} else {
  $begin = 1;
  $end   = $nummsgs;
  $page  = 1;
}

if ($check->Nmsgs != 0) $sorted = imap_sort($imp->stream, $imp->sortby, $imp->sortdir, SE_UID);
else $sorted = array();
$imp->msgl = implode(':', messageRange($sorted, $begin, &$offset, &$beginIndex));
$imp->offset = $offset;
$imp->pickle();
page_close();


$title = "Index of $imp->label";

if ($imp->delhide) {
  $deleted_prompt = $lang->show_deleted;;
}
else {
  $deleted_prompt = $lang->hide_deleted;
}

if ($this_client->lynx) {
  include_lynx_menu(IMPMENU_MAIN);
  include "$default->include_dir/mailbox/lynx_header.inc";
  include "$default->include_dir/mailbox/lynx_navbar_top.inc";
  include "$default->include_dir/mailbox/lynx_actions.inc";
  include "$default->include_dir/mailbox/lynx_message_headers.inc";
} else {
  include "$default->include_dir/mailbox/header.inc";
  include "$default->include_dir/mailbox/navbar_top.inc";
  include "$default->include_dir/mailbox/actions.inc";
  include "$default->include_dir/mailbox/message_headers.inc";
}

// now step through each message
for ($i = $begin, $j = $beginIndex; $i <= $end; $i++, $j++) {
  $msgnum = $sorted[$i-1];
  $h = @imap_header($imp->stream, imap_msgno($imp->stream, $msgnum));
  
  /* Start of deleted message hiding code ... */
  if (($imp->delhide) && ($h->Deleted == 'D')) {
    $delnum++;
  }
  /* Display the message ... */
  else {
    
    /* initialize the header fields */
    $dat = '';
    $frm = '';
    $sub = '';
    $msg_size = '?';
    /* now pull the IMAP header values into them, decoding and chopping them at the same time */
    
    /* formats the header date string nicely */
    if (empty($h->udate)) {
      $dat = '';
    } else {
      if (date('Y', $h->udate) != date('Y')) { // if it's not this year use // MM/DD/YY
	$dat = strftime('%m/%d/%Y', $h->udate);
      } else if ((date('M') != date('M', $h->udate)) || (date('d') != date('d', $h->udate))) { // not today, use DD MMM
	$dat = strftime('%d %b', $h->udate);
      } else { // else it's today, use the time HH:MM
	$dat = strftime('%l:%M %p', $h->udate); // cjh: make this 12hr and add am/pm?
      }
    }
    
    if (isset($h->from[0])) {
      $from = $h->from[0];
      if (isset($from->personal)) {
	$frm = trim(decode_mime_string($from->personal));
      } else if (isset($from->mailbox) && isset($from->host)) {
	$frm = $from->mailbox . '@' . $from->host;
      } else if (isset($h->fromaddress))
	$from = trim(decode_mime_string($h->fromaddress));
    } else if (isset($h->fromaddress)) $frm = trim(decode_mime_string($h->fromaddress));
    
    if (isset($h->fromaddress) && display_toaddress($imp->user, $imp->server, $h->fromaddress)) {
      if (isset($h->toaddress)) {
	$to = chop(decode_mime_string($h->toaddress));
      } else {
	$to = $lang->undisclosed_recipients;
      }
      $frm = $lang->to_label . ': ' . $to;
    }
    if (isset($h->subject)) $sub = trim(decode_mime_string($h->subject));
    if (isset($h->Size)) $msg_size = ($h->Size > 1024) ? sprintf('%.0f kb', $h->Size / 1024) : $h->Size;
    if (strlen($frm) > $default->max_frm_chars) $frm = substr($frm, 0, $default->max_frm_chars) . '...';
    if (strlen($sub) > $default->max_sub_chars) $sub = substr($sub, 0, $default->max_sub_chars) . '...';
    
    /* make sure that they get put into an HTML readable format */
    $frm = htmlspecialchars($frm);
    $sub = htmlspecialchars($sub);
    
    /* set them to useful things for IMP if they ended up being empty */
    if ($dat == '') { $dat = '&nbsp;'; }
    if ($frm == '') { $frm = '&nbsp;'; }
    if ($sub == '') { $sub = $lang->no_subject; } // make sure to have something here for the link text
    
    $icons = array();
    
    $has_attachment = false;
    $flag = array();
    $structure = @imap_fetchstructure($imp->stream,imap_msgno($imp->stream, $msgnum));
    
    $num_parts = @count($structure->parts);
    $bodypart = 1;
    if (is_array($structure->parts) && $num_parts > 0) {
      $has_attachment = true;
    } else {
      /* Only one part in message, check for an attachment */
      $mime = new mime_part_data;
      $mime->set_imap_data($msgnum, 0, $imp->mailbox);
      $mime->parse($structure);
      if ($mime->type_text != 'text' || $mime->subtype != 'plain' )
	$has_attachment = true;
    }
    
    // decide what to do in the from column
    if ($default->from_link == 'none')
	$from_link = $frm;
    else if ($default->from_link == 'compose')
	$from_link = '<a href="javascript:open_compose_win(\'actionID=' . MAILTO . '&mailbox=' . urlencode($imp->mailbox) . "&index=$msgnum&bodypart=1');\">$frm</a>";
    else
	$from_link = '<a href="' . $sess->url('message.php3?mailbox=' . urlencode($imp->mailbox) . "&index=$msgnum&array_index=" . ($i-1)) . '">' . $frm . '</a>';
    
    include "$default->include_dir/mailbox/message_summaries.inc";
  } // for deleted message hiding
} // end message display loop

if ($delnum > 0) {
  include "$default->include_dir/mailbox/deleted_summary.inc";
}

if ($end == 0) {
  include "$default->include_dir/mailbox/empty_mailbox.inc";
}

require "$default->include_dir/mailbox/message_footers.inc";
require "$default->include_dir/mailbox/actions.inc";
require "$default->include_dir/mailbox/navbar_bottom.inc";
require "$default->include_dir/mailbox/footer.inc";
require './lib/js/open_compose_win.js';
require "$default->include_dir/mailbox/javascript.inc";
require './lib/js/open_contacts.js';

if ((isset($actionID) && ($actionID == IMP_LOGIN)) || (isset($horde_frames))) {
  include "$default->include_dir/mailbox/refresh_toolbar-javascript.inc";
}

if (!$this_client->lynx) {
  status ($status_string, $status_color);
}

?>
