<?php

/*
 
 File: status.php3
 $Author: chuck $
 $Revision: 2.7.2.1 $
 $Date: 1999/08/07 21:11:36 $
 
 IMP: Copyright 1998, 1999 by Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */

$need_horde_db = 0;
$db_lib_loaded = 0;
if (!defined("HORDE_LIB")) include '../lib/horde.lib';
require './lib/imp.lib';
require './config/defaults.php3';

/* Html styles configuration */
require './config/html.php3';
require './config/mailbox.php3';

/* get some locale stuff defined elsewhere to minimize locale impact */
$language = select_lang();
require "./locale/$language/message.lang";
require "./locale/local/message.lang";
$Lang_From = $lang->from;
$Lang_Subject = $lang->subject;
/* end relocatable stuff (for 2.1) */

$language = select_lang();
require "./locale/$language/status.lang";
require './locale/local/status.lang';

/* send headers to ensure that the page will reload correctly. */
caching_headers();
$sidebar = true;

/* can we log in? */
page_open(array('sess' => 'HordeSession'));
page_close();
if (isset($imp)) $imp->unpickle();
$title = $lang->status_title;

/* doctype */
require "$default->include_dir/doctype.inc";

/* if we can log in, do so and get the mail stats for this mailbox */
if (isset($default->refresh_delay) && isset($imp) && isset($imp->user) && $imp->user != '') {
  /* make it refresh */
  $refresh = true;
  
  $imp->authenticate(OP_READONLY);
  $mailinfo = imap_mailboxmsginfo($imp->stream);
  if ($mailinfo) {
    $message = $lang->mailbox_status($message, $mailinfo->Unread, $mailinfo->Recent);
    
    /* If they want it, we can give them a "new mail" popup */
    if ($default->newmail_popup) {
      if ($mailinfo->Recent > 0) {
	/* Grab the From and Header of the most recent one */
	$h = imap_header($imp->stream, $mailinfo->Nmsgs);
	
	/* initialize the header fields */
	$frm = '';
	$sub = '';
	
	if (isset($h->from[0])) {
	  $from = $h->from[0];
	  if (isset($from->personal)) {
	    $frm = trim(decode_mime_string($from->personal));
	  } else if (isset($from->mailbox) && isset($from->host))
	    $frm = $from->mailbox . '@' . $from->host;
	  else if (isset($h->fromaddress))
	    $frm = trim(decode_mime_string($h->fromaddress));
	} else if (isset($h->fromaddress))
	  $frm = trim(decode_mime_string($h->fromaddress));
	if (isset($h->subject)) $sub = trim(decode_mime_string($h->subject));
	
	if (strlen($frm) > $default->max_frm_chars) $frm = substr($frm, 0, $default->max_frm_chars) . '...';
	if (strlen($sub) > $default->max_sub_chars) $sub = substr($sub, 0, $default->max_sub_chars) . '...';
	
	echo '<script>onLoad="mail_popup()";';
	echo 'alert("' . $lang->newmail_msg . '\n\n' .
	  $Lang_From . ': ' .
	  $frm . '\n' .
	  $Lang_Subject . ': ' .
	  $sub . '");</script>';
      }
    }
  }
}

require "$default->include_dir/generic-header.inc";
require "$default->include_dir/status/body.inc";
require "$default->include_dir/generic-footer.inc";

?>
