<?php

/*
 
 File: prefs.php3
 $Author: chuck $
 $Revision: 2.10.2.2 $
 $Date: 1999/08/07 21:11:36 $
 
 IMP: Copyright 1999 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */

$need_horde_db = 1;
$db_lib_loaded = 0;
if (!defined("HORDE_LIB")) include '../lib/horde.lib';
require './lib/imp.lib';              /* IMPlib is the IMP function library  */
require './config/defaults.php3';     /* Defaults configuration file */

/* Html styles configuration */
require './config/html.php3';

$language = select_lang();

require './locale/en/prefs.lang';
if ($language != 'en') include "./locale/$language/prefs.lang";
require './locale/local/prefs.lang';

error_reporting($default->error_level);  /* set error level from imp.lib   */

/* retrieve authentication information from session */
page_open(array('sess' => 'HordeSession'));
page_close();
if (!isset($imp) || !is_object($imp)) { header('Location: ' . $sess->purl('login.php3?reason=logout')); exit; }
$imp->unpickle();

$errormsg = '';
/* Run through the action handlers */
if (isset($actionID)) {
  switch($actionID) {
  case NO_ACTION:
    break;
    
  case UPDATE_PREFS:
    $updated = true;
    if (isset($signature) && ($signature != $old_signature)) {
      if (!(imp_set_signature(addslashes($signature), $imp->user, $imp->server))) {
        $errormsg .= $lang->signature_error;
        $updated = false;
      }
    }
    
    if (isset($new_lang) && ($new_lang != $old_lang)) {
      if (!(imp_set_lang($new_lang, $imp->user, $imp->server))) {
	$errormsg .= $lang->language_error;
      }
      $imp->setLang($new_lang);
      $language = $new_lang;
      include "./locale/$language/prefs.lang";
      include "$default->include_dir/mailbox/refresh_toolbar-javascript.inc";
    }
    
    if (isset($from) && ($from != $old_from)) {
      if (!(imp_set_from($from, $imp->user, $imp->server))) {
        $errormsg .= $lang->from_error;
        $updated = false;
      }
    }
    
    if (isset($fullname) && ($fullname != $old_fullname)) {
      if (!(imp_set_fullname(addslashes($fullname), $imp->user, $imp->server))) {
        $errormsg .= $lang->fullname_error;
        $updated = false;
      }
    }
    break;
  }
}

$langs = '<select name="new_lang">';
while (list($key, $val) = each($lang->lang)) {
  if ($key == $language) $sel = ' SELECTED';
  else $sel = '';
  $langs .= "<option value=\"$key\"$sel>$val</option>\n";
}
$langs .= '</select>';

$title = $lang->prefs_title;
$sidebar = false;

require "$default->include_dir/doctype.inc";
require "$default->include_dir/generic-header.inc";
require "$default->include_dir/prefs/begin.inc";
require "$default->include_dir/prefs/signature.inc";
if ($default->user_change_fullname) include "$default->include_dir/prefs/fullname.inc";
if ($default->user_change_from) include "$default->include_dir/prefs/from.inc";
if ($default->user_change_language) include "$default->include_dir/prefs/lang.inc";
require "$default->include_dir/prefs/end.inc";
require "$default->include_dir/generic-footer.inc";

?>
