<?php

/*
  
  File: menu.php3
  $Author: chuck $
  $Revision: 2.9.2.2 $
  $Date: 1999/08/10 14:26:46 $
  
  IMP: Copyright 1998, 1999 Charles J. Hagenbuch <chuck@horde.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/

function set_menu ($text) {
  global $default;
  
  /* skip any comment lines */
  if (ereg("([^#]*)#.*", $text, $regs)) {
    $text = $regs[1];
    
    /* If there was something before the comment, make it a complete line */
    if (strlen($text) > 0) {
      $text = $text . "\n";
    }
  }
  if (strstr($text, '<SEPERATOR>')) {
    $text = '<tr><td colspan="2">&nbsp;</td></tr>' . "\n";
  } else if (ereg("(.*)<(.*)>(.*)\n", $text, $regs)) {
    $text = '<tr bgcolor="' . $default->dark_bg. '"><td valign="top"><a href="' . $regs[1]. '" target="_blank"><img border="0" align="top" src="' . $default->graphics_url . '/' . $regs[3] . '" width="18" height="18" alt="' . $regs[2] . '"></a></td><td><a href="' . $regs[1]. '" target="_blank"><font size="' . $default->font->size . '" face="' . $default->font->face. '">' . $regs[2] . '</font></a></td></tr>' . "\n";
  }
  return $text;
}


$need_horde_db = 0;
$db_lib_loaded = 0;
if (!defined("HORDE_LIB")) include '../lib/horde.lib';
require './lib/imp.lib';           /* IMPlib is the IMP function library  */
require './config/defaults.php3';  /* Defaults configuration file */
require '../config/horde.php3';

/* Html styles configuration */
require './config/html.php3';

$language = select_lang();
require './locale/en/menu.lang';
if( $language != 'en' ) require "./locale/$language/menu.lang";
require './locale/local/menu.lang';

error_reporting($default->error_level);  /* set error level from imp.lib   */

/* if there is an existing session, display the full menu */
page_open(array('sess' => 'HordeSession'));
page_close();
if (isset($imp)) {
    $menu = IMPMENU_MAIN;
    $imp->unpickle();
}

$extra_menus = '';
$menu_array = @file('./config/menu.txt');
for ($j = 0; $j < count($menu_array); $j++) {
  $extra_menus .= set_menu($menu_array[$j]);
}

if (!isset($menu)) $menu = IMPMENU_DORMANT;
if ($menu == IMPMENU_DORMANT) $title = $lang->login_again;

$sidebar = true;
require "$default->include_dir/doctype.inc";
require "$default->include_dir/generic-header.inc";
require './lib/js/open_compose_win.js';
require './lib/js/open_contacts.js';
if ($menu != IMPMENU_BLANK) {
  include "$default->include_dir/menu/main.inc";
}
include "$default->include_dir/generic-footer.inc";

?>
