<?php

$IMAPServers = array();

/*
  This is the IMAP server config file. You need this if you set
  $default->user_change_server to false and $default->use_server_list
  The IMAPServer class contains the following variables:
  
  $name;
  $server;
  $port;
  $folders;
  $from_server;
  $preferred;
  $servtype
  
  name specifies the name to be displayed for the server in the select
  box, server is the hostname of the server. port is the imap port -
  by default 143. folders is the $folders variable to use; by default
  it's set to ''.
  
  preferred is only useful if you do want to use the same server.php3
  file for different machines: if the Hostname of the IMP Machine is
  identical to one of those in the preferred list, then the according
  option in the select box will include a SELECTED, ie. it is selected
  per default. Otherwise the first entry in the list is selected.
  
  servtype is one of 'imap' or 'pop3'. If it's pop3 you're going to be
  connecting to a POP3 mail server instead of IMAP (so make sure the
  port is correct), and all folder options will be automatically
  turned off.
  
  Following are a bunch of example configurations:
*/

$IMAPServers['nirgal'] = new IMAPServer('Nirgal',
					'nirgal.horde.org',
					143,
					'',
					'horde.org');

$IMAPServers['nirpop'] = new IMAPserver('Nirgal - POP Access',
					'nirgal.horde.org',
					110,
					'',
					'horde.org',
					'',
					'pop3');

$IMAPServers['gertrude'] = new IMAPServer('Gertrude',
					  'wso.williams.edu',
					  143,
					  '',
					  'wso.williams.edu');

$IMAPServers['mail1'] = new IMAPServer('Mail1 (Institutsangeh&ouml;rige)',
				       'mail1.uibk.ac.at',
				       143,
				       'mail/',
				       'uibk.ac.at',
				       array("webmail1.uibk.ac.at", "mm1-c102.uibk.ac.at"));

$IMAPServers['mail2'] = new IMAPServer('Mail2 (Studierende)',
				       'mail2.uibk.ac.at',
				       143,
				       'mail/',
				       'uibk.ac.at',
				       'webmail2.uibk.ac.at');

$IMAPServers['mail3'] = new IMAPServer('Illustration of Defaults',
				       'mail.default.com');

?>
