<?php
/* file: defaults.php3 */

/* For debugging purposes */
$default->error_level                    = 15;


/* The longest that things like file uploads and slow functions */
/* should be allowed to run. 0 means run until termination */
/* (forever if infinite loop). */


/* NOTE: you can't set this to 0 if safe_mode is on. */
$default->max_execution_time             = 0;


/* Server Specific Configuration */
$default->localhost                      = "www.csh.rit.edu";


/* Web Server Configuration */
$default->root_url                       = "/~jon/proj/web/horde/imp";
$default->include_dir                    = "./templates";
$default->graphics_url                   = "/~jon/proj/web/horde/imp/graphics";


/* Default IMAP Server Configuration */
$default->server                         = "imap.csh.rit.edu";
$default->from_server                    = "csh.rit.edu";
$default->port                           = "143";
$default->to_domain						 = "csh.rit.edu";

/* Default IMAP Folder Configuration */
$default->folders                        = "Mail/";
$default->use_imap_subscribe             = true;
$default->show_dotfiles                  = false;
$default->save_sent_mail                 = true;
$default->sent_mail                      = "sent-mail";
$default->postponed                      = "postponed";

/* Allow caching of the pages */
$default->cache_pages                    = false;

/* Mailbox listing */
$default->from_link						 = 'none';

/* Ldap searching */
$default->use_ldap_search                = true;
$default->menu_contacts_link             = false;

/* New User link */
$default->newuser_link                   = true;

/* Server list : user is presented with a list */
/* of available imap servers */
$default->use_server_list                = false;

/* User changeable items */
$default->user_change_server             = true;
$default->user_change_folder             = true;
$default->user_change_from               = true;
$default->user_change_fullname           = true;
$default->user_use_addressbook           = true;
$default->user_use_folders				 = true;


/* Check For New Mail Configuration */
$default->newmail_popup                  = false;
$default->refresh_delay                  = "300";


/* Cookie Configuration */
$default->cookie_timeout                 = 300;
$default->session_enabled                = 1;
$default->session_timeout                = "10000";


/* External Binaries Configuration */
$default->path_to_sendmail               = "/usr/sbin/sendmail";
$default->path_to_ispell                 = "/usr/local/bin/ispell";
$default->path_to_mswordview             = "";
$default->path_to_tar                    = "/usr/local/bin/gtar";

/* SSL Configuration */
$default->secure                         = true;


/* Default Language Configuration */
$default->language                       = "en";


/* Message Configuration */
$default->append_header                  = true;
$default->append_trailer                 = false;


/* Text Viewing */
$default->text_parts_inline              = true;


/* Database Configuration */
$default->use_db                         = true;
$default->db_user_name                   = "imp";
$default->db_password                    = "apeshit";
$default->db_name                        = "imp";
$default->db_server_name                 = "localhost";
$default->db_pref_table                  = "imp_pref";
$default->db_address_table               = "imp_addr";
$default->db_connect_string              = "";
$default->db_server_port                 = "";
$default->db_server_options              = "";
$default->db_server_tty                  = "";

/* syslog stats */
$default->log_stats                 = true;
$default->log_stats_facil           = LOG_LOCAL4;
$default->log_prio                  = LOG_NOTICE;
$default->log_ident                 = 'IMP';

/* /var/log/secure (or /var/log/authlog) login/logout/failure logging
*/
$default->log_auth                  = true;
$default->log_auth_facil            = LOG_AUTH;

?>
