<?php

/* the session file (dbm file) */
$default->session_file = './lib/sessions';

/* Email address to send problem reports */
$default->problem_email             = 'chuck@horde.org';
$default->problem_reporting         = true;

/* For debugging purposes */
$default->error_level               = E_ALL;

/* The longest amount of time (in seconds) that things like file uploads
 * and slow functions should be allowed to run. 0 means run until termination
 * (forever if there is infinite loop).
 * NOTE: you can't set this to 0 if safe_mode is on. */
$default->max_execution_time        = 0;

/* Server Specific Configuration */
$default->localhost                 = 'ssl.horde.org';

/* Imap Server Default */
$default->server                    = 'horde.org';
$default->from_server               = 'horde.org';
$default->port                      = 143;

/* Web server configuration */
$default->root_url                  = '/imp';
$default->include_dir               = './templates';
$default->graphics_url              = $default->root_url . '/graphics';

/* Folder configuration */
$default->folders                   = 'mail/';
$default->use_imap_subscribe        = true;
$default->show_dotfiles             = false;
$default->sent_mail                 = 'sent-mail';
$default->save_sent_mail            = true;
$default->postponed                 = 'postponed-msgs';

/* Allow caching of the pages */
$default->cache_pages               = false;

/* Ldap searching */
$default->use_ldap_search           = true;

/* user is presented with an list of available imap servers */
$default->use_server_list           = false;

/* User changable items */
$default->user_change_server        = true;
$default->user_change_folder        = true;
$default->user_change_from          = true;
$default->user_change_fullname      = true;
$default->user_use_addressbook      = true;

/* New mail configuration */
/* Refresh between check for new mail */
$default->refresh_delay		         = 300;
$default->newmail_popup		         = true;

/* Cookie configuration */
$default->session_enabled           = false;
$default->session_timeout           = 1000000;
$default->cookie_timeout            = 1000000;

/* Path to sendmail */
$default->path_to_sendmail          = '/usr/sbin/sendmail';

/* Ispell setup */
$default->path_to_ispell            = '/usr/bin/ispell';

/* Mswordview setup */
$default->path_to_mswordview        = '/usr/bin/mswordview -c';

/* path to tar so that tarballs can be listed */
$default->path_to_tar               = '/bin/tar';

/* SSL Configuration block */
$default->secure                    = true;

/* Cyrus configuration block */
$default->personal_folders          = '';
// cyrus configs may look like this:
// $default->personal_folders       = 'INBOX.';

/* Default Language */
$default->language                  = 'en';

$default->append_header             = false;
$default->append_trailer            = false;

$default->text_parts_inline         = true;

/* database config */
$default->use_db                    = true;
$default->db_user_name              = 'nobody';
$default->db_password               = '';
$default->db_name                   = 'test';
$default->db_server_name            = 'localhost';
$default->db_pref_table             = 'imp_pref';
$default->db_address_table          = 'imp_addr';
$default->db_connect_string         = '';
$default->db_server_port            = '';
$default->db_server_options         = '';
$default->db_server_tty             = '';

/* IMP Signup */
$default->signup_email              = 'chuck@horde.org';  
$default->signup                    = false; 

?>
