<?php

/*
 
 File: contacts.php3
 $Author: chuck $
 $Revision: 2.6.2.1 $
 $Date: 1999/08/07 21:11:35 $
 
 IMP: Copyright 1999 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */


$need_horde_db = 1;
$db_lib_loaded = 0;
if (!defined("HORDE_LIB")) include '../lib/horde.lib';
require './lib/imp.lib';              /* IMPlib is the IMP function library  */
require './config/ldap.php3';
require './config/defaults.php3';     /* Defaults Configuration File */
/* Html styles configuration */
require './config/html.php3';

$language = select_lang();
require './locale/en/contacts.lang';
if ($language != 'en') include "./locale/$language/contacts.lang";
require './locale/local/contacts.lang';
/* Setup the this_client object */
$this_client = new WebClient;

error_reporting($default->error_level);  /* set error level from imp.lib   */

/* send headers to ensure that the page will reload correctly. */
caching_headers();

/* retrieve authentication information from session */
page_open(array('sess' => 'HordeSession'));
page_close();
if (!isset($imp) || !is_object($imp)) { echo '<script language="JavaScript">window.close()</script>'; exit; }
$imp->unpickle();
$imp->authenticate(OP_READONLY);

/* doctype */
require("$default->include_dir/doctype.inc");


/* Run through the action handlers */
if (isset($actionID)) {
   if (strcspn($actionID, '0123456789')) { $actionID = $actions[$actionID]; }

   switch($actionID) {
    case NO_ACTION:
      break;
 
    case ADD_CONTACT:
       if ($imp->mailbox && $index && $bodypart) {
         $h = imap_header($imp->stream, imap_msgno($imp->stream, $index));
         if (isset($h->reply_toaddress)) { $new_address = chop(htmlspecialchars($h->reply_toaddress)); }
         elseif (isset($h->fromaddress)) { $new_address = chop(htmlspecialchars($h->fromaddress )); }
         else $new_address = '';

         if (ereg("(.*)<(.*)>", $h->reply_toaddress, $regs)) {
            $new_fullname = $regs[1];
            $new_fullname = ereg_replace('"', '', $new_fullname); // remove "
            $new_fullname = ereg_replace("'", '', $new_fullname); // remove '
            $new_address = $regs[2];
            if (ereg("(.*)@(.*)", $new_address, $nregs)) {
                $new_nickname = $nregs[1];
            } else {
                $new_nickname = "";
            }
         } else {
            $new_address = chop(htmlspecialchars($h->reply_toaddress));
            if (ereg("(.*)@(.*)", $h->reply_toaddress, $nregs)) {
                $new_nickname = $nregs[1];
                $new_fullname = $nregs[1];
            } else {
                $new_nickname = "";
                $new_fullname = "";
            }
         }




      }
      break;
      
    case ADD_ADDR:
      if ($new_address && $new_nickname && $new_fullname) {
	 $clean_nickname = addslashes($new_nickname);
	 $clean_fullname = addslashes($new_fullname);
	 $clean_address = addslashes($new_address);
	 
	 $errormsg = '';
	 if ($clean_address != $new_address)   $errormsg .= $lang->error_address_chars;
	 if ($clean_nickname != $new_nickname) $errormsg .= $lang->error_nickname_chars;
	 if ($clean_fullname != $new_fullname) $errormsg .= $lang->error_fullname_chars;
	 if (!(imp_add_address($clean_address, $clean_nickname, $clean_fullname, $imp->user, $imp->server))) {
	    $errormsg .= $lang->error_create_address;
	 } else {
         $new_address= '';
         echo '<script language="JavaScript">self.close();</script></body></html>';
       }
      }
      break;
      
   }
}


$title = $lang->addressbook_title;
$sidebar = false;
require("$default->include_dir/generic-header.inc");

if (!isset($new_address)) { $new_address = ''; }


$addresses = imp_get_addresses($imp->user, $imp->server);

$options = '';
if (isset($addresses) && is_array($addresses)) {
   for ($i = 0; $i < count($addresses); $i++) {
      if (is_array($addresses[$i]) && sizeof($addresses[$i] > 1)) {
	 $options .= '    <option value="' . $addresses[$i][0] . '">' . $addresses[$i][1] . ' &lt;' . $addresses[$i][0] . "&gt;\n";
      }
   }
}

require("$default->include_dir/contacts/add-contact-php3.inc");
require("$default->include_dir/generic-footer.inc");
require("$default->include_dir/contacts/javascript.inc");
?>
