<?php

/*
 
 File: status.php3
 $Author: chuck $
 $Revision: 2.7.2.16 $
 $Date: 2000/06/21 03:25:01 $
 
 IMP: Copyright 1998, 1999, 2000 by Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
*/

require '../lib/horde.lib';
require './lib/imp.lib';
require './config/defaults.php3';

/* Html styles configuration */
require './config/html.php3';
require './config/mailbox.php3';
require './lib/version.php';

/* get some locale stuff defined elsewhere to minimize locale impact */
require './config/lang.php3';
$language = select_lang();
require './lib/postconf.php3';
require "./locale/$language/message.lang";
require "./locale/local/message.lang";
$Lang_From = $lang->from;
$Lang_Subject = $lang->subject;
/* end relocatable stuff (for 2.1) */

require "./locale/$language/status.lang";
require './locale/local/status.lang';
$sidebar = true;

/* can we log in? */
page_open(array('sess' => 'HordeSession'));
page_close();
if (isset($imp)) $imp->unpickle();
$title = $lang->status_title;

/* doctype */
require "$default->include_dir/doctype.inc";

/* if we can log in, do so and get the mail stats for this mailbox */
if (isset($default->refresh_delay) && isset($imp) && isset($imp->user) && $imp->user != '') {
  /* make it refresh */
  $refresh = true;
  
  $imp->authenticate(OP_HALFOPEN);
  if ($imp->servtype == 'pop3') {
      $server_string = '{' . $imp->server . ':' . $imp->port . '}';;
  } else {
      $server_string = '{' . $imp->server . ':' . $imp->port . '}' . $imp->mailbox;
  }
  $mailinfo = @imap_status($imp->stream, $server_string, SA_MESSAGES | SA_RECENT | SA_UNSEEN);
  if ($mailinfo) {
    $message = $lang->mailbox_status($message, $mailinfo->unseen, $mailinfo->recent);
    
    /* If they want it, we can give them a "new mail" popup */
    if ($default->newmail_popup) {
      if ($mailinfo->recent > 0) {
	/* reopen the stream to the current mailbox */
	imap_reopen($imp->stream, '{' . $imp->server . ':' . $imp->port . '}' . $imp->mailbox, OP_READONLY);
	/* Grab the From and Header of the most recent one */
	$h = imap_header($imp->stream, $mailinfo->messages);
	
	/* initialize the header fields */
	$frm = '';
	$sub = '';
	
	if (is_object($h)) {
	  if (isset($h->from[0])) {
	    $from = $h->from[0];
	    if (isset($from->personal)) {
	      $frm = trim(decode_mime_string($from->personal));
	    } else if (isset($from->mailbox) && isset($from->host))
	      $frm = $from->mailbox . '@' . $from->host;
	    else if (isset($h->fromaddress))
	      $frm = trim(decode_mime_string($h->fromaddress));
	  } else if (isset($h->fromaddress))
	    $frm = trim(decode_mime_string($h->fromaddress));
	  if (isset($h->subject)) $sub = trim(decode_mime_string($h->subject));
	}
	
	if (strlen($frm) > $default->max_frm_chars) $frm = substr($frm, 0, $default->max_frm_chars) . '...';
	if (strlen($sub) > $default->max_sub_chars) $sub = substr($sub, 0, $default->max_sub_chars) . '...';
	
	echo '<script>onLoad="mail_popup()";';
	echo 'alert("' . addslashes($lang->newmail_msg) . '\n\n' .
	  $Lang_From . ': ' .
	  addslashes($frm) . '\n' .
	  $Lang_Subject . ': ' .
	  addslashes($sub) . '");</script>';
      }
    }
  }
}

require "$default->include_dir/generic-header.inc";
require "$default->include_dir/status/body.inc";
require "$default->include_dir/generic-footer.inc";

?>
