<?php

/*
 
 File: folders.php3
 $Author: chuck $
 $Revision: 2.10.2.21 $
 $Date: 2000/06/23 18:28:24 $
 
 IMP: Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
*/


require '../lib/horde.lib';
require './lib/imp.lib';           /* IMPlib is the IMP function library  */
require './config/defaults.php3';  /* Defaults configuration file */
require '../config/horde.php3';
require './config/html.php3';
require './config/lang.php3';
$language = select_lang();
require './lib/postconf.php3';
require "./locale/$language/folders.lang";
require './locale/local/folders.lang';
$help_file = 'folders.help';
require "./locale/defines/$help_file";

error_reporting($default->error_level);  /* set error level from imp.lib   */

/* retrieve authentication information from session */
page_open(array('sess' => 'HordeSession'));
page_close();
if (!isset($imp) || !is_object($imp)) { header('Location: ' . $sess->url('login.php3?reason=logout')); exit; }
$imp->unpickle();
$imp->authenticate(OP_HALFOPEN);

/* doctype */
require "$default->include_dir/doctype.inc";

$preamble = $imp->folders . $default->personal_folders;
$errormsg = '';
status($lang->status_folders);

/* Run through the action handlers */

if (isset($actionID)) {
	switch($actionID) {
	case NO_ACTION:
		break;
		
	case DELETE_FOLDER:
		if ($dead_mailbox) {
			$dead_mailbox = imap_utf7_encode($dead_mailbox);
			if ($default->use_imap_subscribe) { $boxes = mailbox_list(); }
			if (!@imap_deletemailbox($imp->stream, '{' . $imp->server . ':' . $imp->port . "}$dead_mailbox")) {
				$errormsg = $lang->delete_folder_error;
			} else {
				if ($default->use_imap_subscribe) {
					if (strstr($boxes, "\"$dead_mailbox\"")) {
						if (!@imap_unsubscribe($imp->stream, '{' . $imp->server . ':' . $imp->port . "}$dead_mailbox")) {
							$errormsg = $lang->unsub_folder_error;
						}
					}
				}
			}
		}
		break;
		
	case CREATE_FOLDER:
		if ($new_mailbox) {
			$new_mailbox = imap_utf7_encode($new_mailbox);
			if (!@imap_createmailbox($imp->stream, '{' . $imp->server . ':' . $imp->port . "}$preamble$new_mailbox")) {
				$errormsg = $lang->create_folder_error;
			} else {
				if ($default->use_imap_subscribe) {
					if(!@imap_subscribe($imp->stream, '{' . $imp->server . ':' . $imp->port . "}$preamble$new_mailbox")) {
						$errormsg = $lang->subscribe_folder_error;
					}
				}
			}
		}
		break;
		
	case RENAME_FOLDER:
		if (!empty($old_mailbox) && !empty($new_mailbox)) {
			$old_mailbox = imap_utf7_encode($old_mailbox);
			$new_mailbox = imap_utf7_encode($new_mailbox);
			if ($default->use_imap_subscribe) { $boxes = mailbox_list(); }
			if (!(@imap_renamemailbox($imp->stream, '{' . $imp->server . ':' . $imp->port . "}$old_mailbox", '{' . $imp->server . ':' . $imp->port. "}$preamble" . $new_mailbox))) {
				$errormsg = $lang->rename_folder_error;
			} else {
				if ($default->use_imap_subscribe) {
					if (strstr($boxes, "\"$old_mailbox\"")) {
						@imap_unsubscribe($imp->stream, '{' . $imp->server . ':' . $imp->port . "}$old_mailbox");
						@imap_subscribe($imp->stream, '{' . $imp->server . ':' . $imp->port . "}$preamble$new_mailbox");
					}
				}
			}
		}
		break;
		
	case SUBSCRIBE_FOLDER:
		if (isset($folderAdd)) {
			for ($i = 0; $i < count($folderAdd); $i++) {
				if (strspn($folderAdd[$i], '-') < 5) {
					$folderAdd[$i] = imap_utf7_encode($folderAdd[$i]);
					if (!(@imap_subscribe($imp->stream, '{' . $imp->server . ':' . "$imp->port}$folderAdd[$i]"))) {
						$errormsg = $lang->subscribe_folder_error;
					}
				}
			}
		}
		else {
			$errormsg = $lang->none_selected;
		}
		break;
		
	case UNSUBSCRIBE_FOLDER:
		if (isset($folderRemove)) {
			for ($i = 0; $i < count($folderRemove); $i++) {
				if (strspn($folderRemove[$i],'-') < 5) {
					if (!(@imap_unsubscribe($imp->stream, '{' . "$imp->server:$imp->port}$folderRemove[$i]"))) {
						$errormsg = $lang->unsub_folder_error;
					}
				}
			}
		}
		else {
			$errormsg = $lang->none_selected;
		}
		break;
		
	}
}
if ($errormsg != '') { status($errormsg); }

$title = $lang->folders_title;
require "$default->include_dir/folders/header.inc";

$options = mailbox_list(false, false, false, false);
if ($default->use_imap_subscribe) {
	$unsublist = unsub_mailbox_list(false);
	include "$default->include_dir/folders/subscribe.inc";
}
require "$default->include_dir/folders/create.inc";
require "$default->include_dir/folders/rename.inc";
require "$default->include_dir/folders/delete.inc";
require "$default->include_dir/generic-footer.inc";

?>
